import api from '@/api/editor.api';
import { Module, GetterTree, ActionTree, MutationTree } from 'vuex';
import Vue from 'vue';
import { UPDATE_PAGE_INFO, SET_PAGE_INFO, SET_PAGE_DATA, SET_PAGE_ELEMENTS} from './type';

import RootState from '../../state';
import EditorState, { PageInfo, defaultState, Page, PageElement } from './state';

export default class EditorModule implements Module<EditorState, RootState> {
  state: EditorState;

  getters: GetterTree<EditorState, RootState> = {
    pageData(state) {
      return state.pageInfo.page;
    },
    pageInfo(state) {
      return state.pageInfo;
    }
  };

  actions: ActionTree<EditorState, RootState> = {
    async getPageDate({ commit }, condition) {
      const [res] = await api.getPageById(condition);
      const { page, ...rest } = res as PageInfo;
      commit(SET_PAGE_INFO, { ...rest, page: JSON.parse(page as string) });
    }
  };

  mutations: MutationTree<EditorState> = {
    [SET_PAGE_INFO](state, data) {
      state.pageInfo = data;
    },
    [UPDATE_PAGE_INFO](state, { containerIndex, childIndex, data }) {
      const page = (state.pageInfo.page as Page).elements;
      if (childIndex || childIndex === 0) {
        page[containerIndex].child.splice(childIndex, 1, data);
      } else {
        page.splice(containerIndex, 1, data);
      }
    },
    [SET_PAGE_DATA](state, data) {
      state.pageInfo.page = data;
    },
    [SET_PAGE_ELEMENTS](state, data) {
      if (data) { (state.pageInfo.page as Page).elements = data; }
    },
  };

  constructor(initState: EditorState = JSON.parse(JSON.stringify(defaultState))) {
    this.state = initState;
  }
}