#!/usr/bin/env node

"use strict";
const path = require('path');
const apollo = require('@qg/apollo-nodejs');

const npm = require("npm");
npm.load(() => {
  apollo.load({
    appId: 'quantum-block-h5',
    configPath: path.resolve(__dirname, '../config'),
  }).then(() => {
    console.log(">>> apollo file", require(path.resolve('./config/apollo.json')));
    if (process.env.NODE_ENV === 'production') {
      npm.run("start"); 
    } else {
      npm.run("test");
    }
  });

});

 