import { RC, DEFAULTS } from './constants';
import { decode, encode } from 'ini';
import { promisify } from 'util';
import chalk from 'chalk';
import fs from 'fs';

const exits = promisify(fs.exists);
const readFile = promisify(fs.readFile);
const writeFile = promisify(fs.writeFile);

//RC 是配置文件
//DEFAULTS 是默认的配置

const initRc = async () => {
    const exit = await exits(RC);
    if (!exit) {
        await writeFile(RC, encode(DEFAULTS), 'utf8');
    }
}
export const get = async (key) => {
    await initRc();
    let opts = await readFile(RC, 'utf8');
    opts = decode(opts);
    return opts[key];
}

export const getAll = async () => {
    await initRc();
    let opts = await readFile(RC, 'utf8');
    opts = decode(opts);
    return opts;
}

export const set = async (key, value) => {
    await initRc();
    let opts = await readFile(RC, 'utf8');
    opts = decode(opts);
    if(!key) {
        console.log(chalk.red(chalk.bold('Error:')), chalk.red('key is required'));
        return;
    }
    if(!value) {
        console.log(chalk.red(chalk.bold('Error:')), chalk.red('value is required'));
        return;
    }
    Object.assign(opts, { [key]: value });
    await writeFile(RC, encode(opts), 'utf8');
}

export const remove = async (key) => {
    await initRc();
    let opts = await readFile(RC, 'utf8');
    opts = decode(opts);
    delete opts[key];
    await writeFile(RC, encode(opts), 'utf8');
}