import program from 'commander';
import { VERSION } from './utils/constants';
import apply from './index';
import chalk from 'chalk';

/**
 * qg commands
 *    - config
 *    - init 
 */

let actionMap = {
    init: {
        description: 'generate a new project from a template',
        usages: [
            'qg init templateName projectName'
        ]
    },
    config: {
        alias: 'cfg',
        description: 'config .qgrc',
        usages: [
            'qg config set <k> <v>',
            'qg config get <k>',
            'qg config remove <k>'
        ]

    },
    block: {
        description: 'add a block to destination',
        usages: [
            'qg block list',
            'qg block add <blockName>'
        ]
    }
    //other commands
}

// 添加 init / config 命令
Object.keys(actionMap).forEach((action) => {
    program.command(action)
    .description(actionMap[action].description)
    .alias(actionMap[action].alias) //别名
    .action(() => {
        switch (action) {
            case 'config': 
                //配置
                apply(action, ...process.argv.slice(3));
                break;
            case 'init':
                apply(action, ...process.argv.slice(3));
                break;
            case 'block':
                apply(action, ...process.argv.slice(3));
                break;
            default:
                break;
        }
    });
});

function help() {
    console.log('\r\nUsage:');
    Object.keys(actionMap).forEach((action) => {
        actionMap[action].usages.forEach(usage => {
            console.log('  - ' + usage);
        });
    });
    console.log('\r');
}
program.usage('<command> [options]');
// qg -h 
program.on('-h', help);
program.on('--help', help);
// qg -V   version 为 package.json 中的版本号
program.version(VERSION, '-v --version').parse(process.argv);

// qg 不带参数时
if (!process.argv.slice(2).length) {
    program.outputHelp(make_green);
}
function make_green(txt) {
    return chalk.green(txt); 
}