'use strict';

var _get = require('./utils/get');

var _rc = require('./utils/rc');

var _ora = require('ora');

var _ora2 = _interopRequireDefault(_ora);

var _inquirer = require('inquirer');

var _inquirer2 = _interopRequireDefault(_inquirer);

var _fs = require('fs');

var _fs2 = _interopRequireDefault(_fs);

var _chalk = require('chalk');

var _chalk2 = _interopRequireDefault(_chalk);

var _logSymbols = require('log-symbols');

var _logSymbols2 = _interopRequireDefault(_logSymbols);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _asyncToGenerator(fn) { return function () { var gen = fn.apply(this, arguments); return new Promise(function (resolve, reject) { function step(key, arg) { try { var info = gen[key](arg); var value = info.value; } catch (error) { reject(error); return; } if (info.done) { resolve(value); } else { return Promise.resolve(value).then(function (value) { step("next", value); }, function (err) { step("throw", err); }); } } return step("next"); }); }; }

const util = require('util');
const exec = util.promisify(require('child_process').exec);

let block = (() => {
    var _ref = _asyncToGenerator(function* (action, blockName) {
        let result = yield (0, _rc.get)('block');
        switch (action) {
            case 'add':
                if (_fs2.default.existsSync('block')) {
                    yield exec('rm -rf block');
                }
                if (!result.includes(blockName)) {
                    console.log(_logSymbols2.default.error, _chalk2.default.red(`The blockName ${blockName} not exists`));
                    return;
                }
                //命令行交互
                _inquirer2.default.prompt([{
                    name: 'destination',
                    message: 'Please enter the destination:(default src/view/) '
                }]).then((() => {
                    var _ref2 = _asyncToGenerator(function* (answer) {
                        if (answer.destination && !_fs2.default.existsSync(answer.destination)) {
                            console.log(_logSymbols2.default.error, _chalk2.default.red('The destination not exists'));
                            return;
                        }
                        let loading = (0, _ora2.default)('downloading block ...');
                        loading.start();
                        (0, _get.downloadBlock)().then(function () {
                            loading.succeed();
                            const destination = answer.destination ? `${answer.destination}` : 'src/view/';
                            exec(`cp -r block/${blockName} ${destination} && rm -rf block`);
                        }, function (e) {
                            loading.fail(e.message);
                        });
                    });

                    return function (_x3) {
                        return _ref2.apply(this, arguments);
                    };
                })());
                break;
            case 'list':
                result.forEach(function (block) {
                    return console.log(block + '\r');
                });
                break;
            default:
                break;
        }
    });

    return function block(_x, _x2) {
        return _ref.apply(this, arguments);
    };
})();

module.exports = block;