import { getAll } from './rc';
import downloadGit from 'download-git-repo';

export const downloadLocal = async (templateName, projectName) => {
    let config = await getAll();

    let api = `direct:${config.address}/${config.type}/${config[templateName]}`;
    console.log(`\ndownload from ${api}`);
    return new Promise((resolve, reject) => {
        //projectName 为下载到的本地目录
        downloadGit(api, projectName, { clone: true }, (err) => {
            if (err) {
                reject(err);
            }
            resolve();
        });
    });
}

export const downloadBlock = async () => {
    let config = await getAll();

    let api = `direct:${config.address}/${config.type}/block.git`;
    console.log(`\ndownload from ${api}`);
    return new Promise((resolve, reject) => {
        //projectName 为下载到的本地目录
        downloadGit(api, 'block', { clone: true }, (err) => {
            if (err) {
                reject(err);
            }
            resolve();
        });
    });
}