const inquirer = require('inquirer');


// 选择项目类型
const getProjectTypeOption = async () => {
  const optionInfo = [
      {
        type: "list",
        name: "projectType",
        default: "H5",
        message: "请选择拉取的项目类型",
        choices: [
          {
            key: 'H5',
            value: 'H5',
            name: 'H5项目(Vue2)'
          },
          {
            key: 'PC',
            value: 'PC',
            name: 'PC项目(Vue3 + Antd + TS)'
          },
        ],
        filter(val) {
          return val;
        }
      }
    ];
  return inquirer.prompt(optionInfo);
};

const dirOptions = async () => {
  const optionInfo = [
    {
      type: "list",
      name: "dirOperation",
      default: true,
      message: "目录已存在，是否覆盖目录创建",
      choices: [
        {
          key: '1',
          value: '1',
          name: '覆盖创建'
        },
        {
          key: '2',
          value: '2',
          name: '终止创建'
        },
      ],
      filter(val) {
        return val;
      }
    }
  ]
  return inquirer.prompt(optionInfo);
}

module.exports = {
  getProjectTypeOption,
  dirOptions
}