import Vue from 'vue';

import App from './App.vue';
import router from './router';
import store from './store';
import '@/service/svg.service';
import '@/service/cherryUI.service';
import './style/index.less';
import saService from '@/service/sa.service';
import Bridge from '@qg/js-bridge';
import { init as sentryInit } from '@sentry/vue';
if (process.env.SENTRY_ENV !== 'test' && process.env.NODE_ENV === 'production') {
  sentryInit({
    Vue,
    dsn: 'http://ab941e35776348e6aed32324658798f3@sentry.q-gp.com/17', // 项目设置中的Client Keys
    release: 'phobos-ui@1.0.0', // 项目名加版本号
    tracesSampleRate: 0.5, // 上报频率, 1最大, 0最小, 建议验证设置为1, 项目运行根据情况降低频率
    environment: process.env.NODE_ENV
  });
}
Vue.prototype.util = new Bridge();
Vue.prototype.$track = saService;
saService.init(router);

Vue.config.productionTip = false;

new Vue({
  router,
  store,
  render: h => h(App)
}).$mount('#app');
