import request from "../utils/request";
import config from "@/config";
const { yxmGateway, SHARE_CHANNEL } = config;

export const confirmOrder = data => {
  return request.post(`${yxmGateway}/api/kdsp/shop-cart/order-confirm/page/v2`, data);
};

export const orderSubmit = data => {
  const options = {
    encrypt: true
  };
  // #ifdef MP-WEIXIN
  const sceneList = [1007, 1008, 1011, 1012, 1013, 1036, 1044, 1047, 1048, 1049, 1058];
  const currentScene = wx.getEnterOptionsSync().scene;
  if (sceneList.indexOf(currentScene) > -1) {
    options.customizeChannel = SHARE_CHANNEL;
  }
  // #endif
  return request.post(`${yxmGateway}/api/kdsp/order-info/e/submit`, data, options);
};
// 校验手机号是否为 推广员手机号
export const checkPromoterByMobile = phone => {
  return request.get(`${yxmGateway}/api/kdsp/self-mention/checkPromoterByMobile?phoneNo=${phone}`);
};
