import user from '@/api/user.api';
import store from '@/store';
import { getQueryString, parseSearch } from './utils.service';
import localStorage from './localStorage.service';
import cookie from './cookieStorage.service';
// eslint-disable-next-line space-before-function-paren
export const getUserInfo = async () => {
  const [data] = await user.getUserInfo();
  const { userInfo } = data || {};
  store.commit('CHANGE_LOGIN', userInfo);
  return userInfo;
};

export const getToKen = () => {
  const vccToken = getQueryString('vccToken');
  const oldToken = localStorage.get('vccToken') || '';
  store.commit('CHANGE_TOKEN', vccToken || oldToken || '');
};

export function getVccChannel(channelKey = 'vccChannel') {
  if (channelKey === 'sonVccChannel') {
    return localStorage.get(channelKey) || parseSearch(window.location.href)[channelKey] || '';
  }
  return localStorage.get(channelKey) || parseSearch(window.location.href)[channelKey] || '';
}

export function getTenantId() {
  return localStorage.get('tenantId') || parseSearch(window.location.href)['tenantId'] || '';
}
export function getUid() {
  // 返利网会员标识
  return cookie.get('uid') || '';
}
export function getTc() {
  // 返利网订单附加跟踪信息
  return cookie.get('tc') || '';
}
