import { getOrderType } from "@/api/pay.api.js";
import config from "@/config";

export async function isHundredGroup(orderNo) {
  try {
    const [res] = await getOrderType(orderNo);
    return res?.hundredGroupOrder || false;
  } catch (err) {
    return false;
  }
}

export async function redirectLocation(orderNo, error, finalAmt, freeAmount, payType) {
  try {
    const isGroup = await isHundredGroup(orderNo);
    if (isGroup) {
      const token = uni.getStorageSync("token") || "";
      const payStatus = error ? "payFail" : "paySuccess";
      const url = `${config.groupBuyHost}/${payStatus}?vccToken=${token}&amount=${finalAmt}&reason=${error}&orderNo=${orderNo}&freeAmount=${freeAmount}&payType=${payType}`;
      uni.redirectTo({
        url: `/pages/groupbuy/webview?url=${encodeURIComponent(JSON.stringify(url))}`
      });
      return true;
    }
    return false;
  } catch (err) {
    return false;
  }
}
