import request from "../utils/request";
import config from "@/config";
import { mpConfig } from "@/utils/mpConfig/types";
const { talosApi, yxmGateway } = config;
export default {
  // 提现
  cashOut(data) {
    return request.get(`${talosApi}/vcc/xyqb/mineMini`, data);
  },
  // 物流信息
  orderLogistics(data) {
    // return request.get("http://yapi.quantgroups.com/mock/351/api/kdsp/logistics/packages-list");
    return request.get(`${yxmGateway}/api/kdsp/logistics/packages-list`, data);
  },
  // 用户订单确认收货接口
  orderConfirm(data) {
    return request.post(`${yxmGateway}/api/kdsp/order-info/receipt/confirm`, data);
  },
  // 用户订单取消接口【未付款】
  orderCancel(data) {
    return request.post(`${yxmGateway}/api/kdsp/order-info/cancel`, data);
  },
  // 用户订单取消接口【已付款】
  orderUnfilledCancel(data) {
    return request.get(`${yxmGateway}/api/kdsp/order-info/unfilled/cancel`, data);
  },
  // 用户订单取消接口【已付款】
  orderUnfilledCancelV2(data) {
    return request.get(`${yxmGateway}/api/kdsp/order-info/unfilled/cancel/v2`, data);
  },
  // 订单取消原因查询接口
  orderCancelList(data) {
    return request.get(`${yxmGateway}/api/kdsp/order-info/cancel-reason/query`, data);
  },
  // 订单取消原因查询接口
  orderCancelListV2(data) {
    return request.get(`${yxmGateway}/api/kdsp/order-info/paid-cancel-props/query`, data, {
      hideToast: true
    });
  },
  // 已发货申请退款催办接口
  orderRemindCancel(data) {
    return request.get(`${yxmGateway}/api/kdsp/order-info/remindCancel`, data);
  },
  // 撤销取消订单申请
  cancelRevoke(data) {
    return request.get(`${yxmGateway}/api/kdsp/order-info/unfilled/cancel-revoke`, data);
  },
  // 取消/售后，获取是否需要签订合同
  orderQueryNote(data) {
    return request.get(`${yxmGateway}/api/kdsp/order-info/queryNote`, data);
  },
  // 订单详情查询接口
  orderDetail(data) {
    return request.get(`${yxmGateway}/api/kdsp/order-info/detail/query`, data);
  },
  // 用户订单列表查询接口
  orderList(data) {
    return request.get(`${yxmGateway}/api/kdsp/order-info/list/query`, data, {
      hideLoading: true
    });
  },
  // 获取信用钱包用户信息
  xhkInfo(data) {
    return request.get(`${yxmGateway}/api/kdsp/profile/vcc/user-account`, data);
  },
  // 我的 查询各状态订单数量
  orderInfo(data) {
    return request.get(`${yxmGateway}/api/kdsp/order-info/status-number`, data);
  },
  // 微信小程序登录
  login(data) {
    return request.post(`${yxmGateway}${mpConfig.loginUrl}`, data, {
      emulateFormData: true
    });
  },
  // 注册
  register(data) {
    // 登录接口添加utm_source
    getCurrentPages().forEach(item => {
      if (item.options?.utm_source) {
        data.utm_source = item.options?.utm_source;
      }
    });
    return request.post(`${yxmGateway}${mpConfig.registerUrl}`, data);
  },
  getAvatar(data) {
    return request.post(`${yxmGateway}/api/kdsp/wx/mini-app/avatar`, data);
  },
  loadArea(id = "") {
    return request.get(`${yxmGateway}/api/kdsp/addr/query?addrId=${id}`);
  },
  saveAddress(data) {
    return request.post(`${yxmGateway}/api/kdsp/addr/receiver/add_edit`, data);
  },
  getAddressList() {
    return request.get(`${yxmGateway}/api/kdsp/addr/receiver/list`);
  },
  deleteAddress(addrReceiverId) {
    return request.post(`${yxmGateway}/api/kdsp/addr/receiver/delete`, {
      addrReceiverId
    });
  },
  apiTest(data) {
    return request.get(`${talosApi}/activity/commonly/free-goods/list`, data);
  },
  // 获取首页活动弹窗
  getUserPopup() {
    return request.get(
      `${yxmGateway}/api/kdsp/app-config-push/profile/popup`,
      {
        page: "profile"
      },
      {
        hideLoading: true
      }
    );
  },
  // 注销登录
  logout(data) {
    return request.post(`${yxmGateway}/api/kdsp/user/user-logged-off`, data);
  },
  // 退出登录
  logoutUser(data) {
    return request.post(`${yxmGateway}/api/kdsp/logout/user`, data);
  }
};
