import { mapGetters as goodsMapGetters, mapActions as goodsMapActions, mapState } from '../store';
import localStorage from '@/service/localStorage.service';
import { mapActions as ShopCartMapActions } from '@/views/shopCart/shopCartModules.js';
import { mapActions } from 'vuex';
import { mapGetters as homeMapGetters } from 'vuex';

export default {
  data() {
    return {
      animTimer: null,
      startAnimate: false
    };
  },
  computed: {
    ...mapState(['popupControl']),
    ...homeMapGetters(['hasLogin']),

    ...goodsMapGetters(['isSelectSpec', 'selectedSku', 'receiverInfo', 'goodsStatus', 'btnTxt']),
    btnGroup() {
      if (['cart', 'buy'].includes(this.popupControl.type)) {
        return [
          {
            text: '确定',
            type: 'primary'
          }
        ];
      }
      const btnGroup = [
        {
          text: this.btnTxt,
          type: 'primary'
        }
      ];
      if (this.goodsStatus === 3 || this.goodsStatus === 31) {
        btnGroup.unshift({
          text: '加入购物车',
          type: 'primary',
          plain: true
        });
      }
      return btnGroup;
    },
    tip() {
      return (
        {
          11: '所选地区暂时无货，看看其他相似商品吧！',
          4: '该商品已下架，看看其他相似商品吧！'
        }[this.goodsStatus] || ''
      );
    }
  },
  methods: {
    ...goodsMapActions(['pickupCouponBySkuNo', 'subscribeAdd', 'setPopupState']),
    ...ShopCartMapActions({
      addToCart: 'add_to_cart'
    }),
    ...mapActions('createOrderStore', ['fetchOrderInfoApi']),
    async onClickRight(e) {
      if (this.popupControl.type === 'buy') {
        e.index = 1;
      }
      if (!this.isSelectSpec) {
        this.$toast('请选择规格后尝试');
        return;
      }
      if (!this.hasLogin) {
        this.$router.push({ name: 'Login' });
        return;
      }
      if (this.goodsStatus === 41) {
        this.$toast('商品已失效');
        return;
      }

      switch (e.index) {
        case 0:
          this.addCart();
          break;
        case 1:
          this.toOrder();
          break;
        default:
          break;
      }
    },
    addCart() {
      const { skuId, skuNum, skuSource } = this.selectedSku;
      this.addCartAnimation();
      this.addToCart({ skuId, skuNum, skuSource });
    },
    addCartAnimation() {
      if (this.animTimer) {
        clearTimeout(this.animTimer);
      }
      this.startAnimate = true;
      this.setPopupState(false);
      this.animTimer = setTimeout(() => {
        this.startAnimate = false;
        clearTimeout(this.animTimer);
      }, 700);
    },
    async toOrder() {
      const { skuId, skuNum, skuSource } = this.selectedSku;
      if (this.goodsStatus === 11) {
        this.subscribeAdd();
        return;
      }
      if (this.goodsStatus === 31) {
        await this.pickupCouponBySkuNo();
      }
      const order = {
        addrReceiverId: this.receiverInfo.id || '',
        selectedSkuList: [
          {
            skuId,
            skuNum,
            skuSource
          }
        ],
        defaultUseCoupon: true,
        defaultUseFreightFeeCoupon: true,
        defaultUseCashCoupon: true,
        defaultUseActivityCoupon: true,
        defaultUseGiftCard: true,
        couponActivityUseIdList: []
      };
      localStorage.set('orderData', order);
      localStorage.remove('addressList');
      this.fetchOrderInfoApi();
      this.$track.registeredEvents(
        'H5_2B_CommodityDetailPageBuyNowBtn',
        {
          commodity_id: skuId
        },
        () => {
          this.$router.push({ name: 'createOrder' });
        }
      );
    },
    goSimilar() {
      const des = this.tip;
      const { skuId: skuNo, imageUrl, skuName } = this.selectedSku;
      const similarData = {
        des,
        skuNo,
        goodsName: skuName,
        goodsImage: imageUrl
      };
      localStorage.set('similarData', similarData);
      this.$router.push({ name: 'Similar' });
    }
  }
};
