import { locationHrefPatch } from '@/service/utils.service';
import { mapGetters } from 'vuex';
import { mapActions as ShopCartMapActions } from '@/views/shopCart/shopCartModules.js';
export default {
  data() {
    return {
      iframeLink: ''
    };
  },
  computed: {
    ...mapGetters(['vccToken'])
  },
  created() {
    window.addEventListener('message', event => {
      console.log('parent', event);
      // 来源页面地址
      if (event.data.event && this.iframeLink.indexOf(event.origin) > -1) {
        this[event.data.event](event.data.data);
      }
    });
  },
  beforeDestroy() {
    window.removeEventListener('message', this.postMsgBack);
  },
  methods: {
    ...ShopCartMapActions(['queryCartCount']),
    postMsgBack(event) {
      console.log('parent', event);
      // 来源页面地址
      if (this.iframeLink === event.data.sourceUrl) {
        this[event.event](event.data);
      }
    },
    run(data) {
      this.$refs.memberCenterIframe.contentWindow.postMessage(data, '*');
    },
    closeBrowser() {
      this.$router.back();
    },
    getToken() {
      if (!this.vccToken) {
        this.$router.replace({ name: 'Login', query: { backUrl: location.href } });
        return;
      }
      this.run({
        event: 'getTokenSuccess',
        data: {
          token: this.vccToken
        }
      });
    },
    openNewUrl(data) {
      locationHrefPatch(data.newUrl, this.$router);
    },
    shopCarAddGoodsNotification() {
      this.queryCartCount();
    },
    getShuMeiId() {}
  }
};
