import http from '@/service/httpDecorator';
import config from '@/config';
import { getServiceHeaders } from '@/service/utils.service';
const { yxmGwHost } = config;

export const queryServiceSku = params => {
  return http.get(`${yxmGwHost}/api/kdsp/sku-info/detail/query/service-sku`, { params });
};

export const searchServiceGoodsResult = () => {
  return http.get(`${yxmGwHost}/api/kdsp/search/service-goods/result`);
};

export const getGoodsList = (type, params) => {
  return http.get(`${yxmGwHost}/api/kdsp/recommend/service-goods/goods-list`, {
    params,
    headers: getServiceHeaders()
  });
};

// 首页接口
export const livingServicePage = () => {
  return http.post(`${yxmGwHost}/api/kdsp/index/living-service/page`, {
    headers: getServiceHeaders()
  });
};
