// 新建 router 配置文件
import { RouterMount, createRouter } from 'uni-simple-router';
import store from "@/store/index.js"
import  ROUTES from "./router/routes.js"
const router = createRouter({
    platform: process.env.VUE_APP_PLATFORM,
    routerErrorEach: ({ type, msg }) => {
        console.log(type, msg);
        switch (type) {
            // APP退出应用
            case 3:
                // #ifdef APP-PLUS
                router.$lockStatus = false;
                uni.showModal({
                    title: '提示',
                    content: '您确定要退出应用吗？',
                    success: function (res) {
                        if (res.confirm) {
                            plus.runtime.quit();
                        }
                    }
                });
                // #endif
                break;
            case 2:
            case 0:
                router.$lockStatus = false;
                break;
            default:
                break;
        }
    },
    routes: [...ROUTES]   // ROUTES 这个名称是webpack 中配置的名称
});

//全局路由前置守卫
router.beforeEach((to, from, next) => {
    if (to.meta && to.meta.currentNav) {
        store.commit('updateCurrentNav', to.meta.currentNav);
    }
    next()
});

export { router, RouterMount }

