export const TAB_LIST = [
  { name: 'OrderProductList', title: '申请发票' },
  { name: 'OrderRecordList', title: '申请记录' },
  { name: 'OrderRiseList', title: '抬头管理' }
];

export const INVOIC_ING = 1;
export const INVOIC_SUCCESS = 2;
export const INVOIC_FAID = 3;
export const INVOIC_CHANGE = 4;
export const INVOIC_CHANGE_SUCCESS = 5;
export const INVOIC_INVALID = 6;

export const invoiceStateConfig = {
  [INVOIC_ING]: { text: '开票中' },
  [INVOIC_SUCCESS]: { text: '开票成功' },
  [INVOIC_FAID]: { text: '开票失败' },
  [INVOIC_CHANGE]: { text: '换开中' },
  [INVOIC_CHANGE_SUCCESS]: { text: '换开成功' },
  [INVOIC_INVALID]: { text: '发票失效' }
};

export const INVOIC_LODING = [INVOIC_ING, INVOIC_CHANGE];

// 1：查看发票，11：分享pfd， 2：灰色重开发票，3：红色重开发票，4：重新发送，5：联系客服,6：授权微信,

export const BUTTON_CONFIG = {
  1: {
    text: '查看发票',
    type: 'default',
    event: 'openPictureUrl'
  },
  11: {
    text: '分享发票',
    type: 'primary',
    event: 'shareInvoice'
  },
  2: {
    text: '重新开票',
    type: 'default',
    event: 'reOpen'
  },
  3: {
    text: '重新开票',
    type: 'primary',
    event: 'reOpen'
  },
  4: {
    text: '重新发送',
    type: 'primary',
    event: 'reSend'
  },
  5: {
    text: '联系客服',
    type: 'primary',
    event: 'goCustomer'
  },
  6: {
    text: '添加至微信卡包',
    type: 'primary',
    event: 'addWeixinCard'
  }
};

export const contentType = {
  1: '商品明细',
  2: '商品类别'
};

export const titleType = {
  1: '个人',
  2: '单位'
};

export const afterStatusConfig = {
  1: '售后中订单暂不支持发票开具',
  2: '该笔订单存在部分退货退款暂不支持发票开具',
  3: '该笔订单已售后成功暂不支持发票开具'
};
