/*
 * @Description:
 * @Date: 2020-12-01 18:06:18
 * @LastEditors: guang.wu
 * @LastEditTime: 2023-04-28 17:20:37
 */
import { parseTime } from '@/service/utils.service';

export function handleRemainTime(start, end) {
  const startTime = (start ? new Date(start.replace(/-|\./g, '/')) : new Date()).getTime();
  const endTime = (end ? new Date(end.replace(/-|\./g, '/')) : new Date()).getTime();
  return [endTime - startTime, startTime, endTime];
}

export function handleDateFormat(start, end, month) {
  const dateArr = handleRemainTime(start, end);
  const isDay = dateArr[0] > 60 * 60 * 1000 * 23;
  const formatExp = month ? '{m}月{d}日' : isDay ? '{m}月{d}日' : '{h}:{i}';
  return {
    isDay,
    dateFormat: parseTime(dateArr[1], formatExp, true),
    dateTime: parseTime(dateArr[1], '{h}:{i}')
  };
}

export function handleRemainTimeForSeckillV2(start, end) {
  const startTime = (start ? new Date(start.replace(/-|\./g, '/')) : new Date()).getTime();
  const endTime = (end ? new Date(end.replace(/-|\./g, '/')) : new Date()).getTime();
  return [endTime - startTime, startTime, endTime];
}

export function handleDateFormatForSeckillV2(start, end, month) {
  const dateArr = handleRemainTime(start, end);
  const isDay = dateArr[0] > 60 * 60 * 1000 * 23;
  const formatExp = isDay ? '{m}月{d}日' : '{h}:{i}';
  let dateFormat = parseTime(dateArr[1], formatExp, month);
  if (formatExp === '{h}:{i}' && dateFormat.split(':')[1] === '00') {
    dateFormat = parseTime(dateArr[1], '{h}:00', false);
  }
  return {
    isDay,
    dateFormat,
    dateTime: parseTime(dateArr[1], '{h}:{i}')
  };
}
