import invoice from './components/invoice';
import promotion from './components/promotion';
import shopCart from './components/shopCart';
import member from './components/member';
import serviceGoods from './components/serviceGoods';
export default [
  {
    path: '/',
    name: 'Home',
    meta: {
      title: '首页'
    },
    component: () => import('../views/home')
  },
  {
    path: '/memberCenter',
    name: 'Member',
    meta: {
      title: '会员'
    },
    component: () => import('../views/memberCenter')
  },
  ...invoice,
  ...promotion,
  ...shopCart,
  ...member,
  ...serviceGoods,
  {
    path: '/user',
    name: 'User',
    meta: {
      title: '我的'
    },
    component: () => import('../views/user')
  },
  {
    path: '/officialLogin',
    name: 'OfficialLogin',
    meta: {
      title: '登录'
    },
    component: () => import('../views/officialAccountLogin/index.vue')
  },
  {
    path: '/login',
    name: 'Login',
    meta: {
      title: '登录',
      cdns: [
        'https://misc.lkbang.net/common/zepto/zepto.min-1.2.0.js',
        'https://jverification.jiguang.cn/scripts/jverification-web.4.0.0.min.js',
        'https://opencloud.wostore.cn/h5netauth/h5login/singleton/h5auth1.min.js',
        'https://jverification.jiguang.cn/scripts/util/crypto-js.js'
      ]
    },
    component: () => import('../views/user/login')
  },
  {
    path: '/loginMiddle',
    name: 'LoginMiddle',
    meta: {
      title: '羊小咩'
    },
    component: () => import('../views/loginMiddle/index.vue')
  },
  {
    path: '/set',
    name: 'set',
    meta: {
      title: '设置'
    },
    component: () => import('../views/set')
  },
  {
    path: '/search',
    name: 'search',
    meta: {
      title: '搜索'
    },
    component: () => import('../views/search')
  },
  {
    path: '/vccNewComer',
    name: 'VccNewComer',
    component: () => import('../views/vccNewComer/index'),
    meta: { title: '享花卡新人专区' }
  },
  {
    path: '/rushBuy',
    name: 'rushBuy',
    component: () => import('../views/rushBuy/index'),
    meta: { title: '抢购活动', show: true }
  },
  {
    path: '/goodDetail',
    name: 'goodDetail',
    meta: {
      title: '商品详情',
      keepAlive: true, // 需要缓存
      cdn: {
        url: 'https://misc.lkbang.net/common/clipboard/2.0.8/clipboard.min.js',
        globalName: 'ClipboardJS'
      }
    },
    component: () => import('../views/product/goodDetail')
  },
  {
    path: '/commentList',
    name: 'commentList',
    meta: {
      title: '评价列表',
      cdn: {
        url: 'https://misc.lkbang.net/common/video.js/6.13.0/video.min.js',
        globalName: 'videojs'
      }
    },
    component: () => import('../views/product/commentList')
  },
  {
    path: '/similar',
    name: 'Similar',
    meta: {
      title: '查看相似'
    },
    component: () => import('../views/product/similar')
  },
  {
    path: '/product/info',
    name: 'info',
    meta: {
      title: '产品信息'
    },
    component: () => import('../views/product/info')
  },
  {
    path: '/bill',
    name: 'bill',
    meta: {
      title: '我的账单'
    },
    component: () => import('../views/bill')
  },
  {
    path: '/stages',
    name: 'stages',
    meta: {
      title: '账单分期'
    },
    component: () => import('../views/billStages')
  },
  {
    path: '/stagesSuccess',
    name: 'stagesSuccess',
    meta: {
      title: '分期结果'
    },
    component: () => import('../views/billStages/stagesSuccess')
  },
  {
    path: '/billDetails',
    name: 'billDetails',
    meta: {
      title: '账单详情'
    },
    component: () => import('../views/billDetails')
  },
  {
    path: '/payBackDetails',
    name: 'payBackDetails',
    meta: {
      title: '还款详情'
    },
    component: () => import('../views/payBackDetails')
  },
  {
    path: '/address',
    name: 'address',
    meta: {
      title: '我的地址'
    },
    component: () => import('../views/address/address')
  },
  {
    path: '/addressManage',
    name: 'addressManage',
    meta: {
      title: '新增地址'
    },
    component: () => import('../views/address/addressManage')
  },

  {
    path: '/orderList',
    name: 'orderList',
    meta: {
      title: '我的订单'
    },
    component: () => import('../views/orderList')
  },
  {
    path: '/expressDetail',
    name: 'expressDetail',
    meta: {
      title: '物流详情',
      cdn: {
        url: 'https://misc.lkbang.net/common/clipboard/2.0.8/clipboard.min.js',
        globalName: 'ClipboardJS'
      }
    },
    component: () => import('../views/expressDetail')
  },
  {
    path: '/createOrder',
    name: 'createOrder',
    meta: {
      title: '确认订单',
      // keepAlive: true, // 需要缓存
      cdn: {
        url: 'https://misc.lkbang.net/common/node-forge/0.10.0/forge.min.js',
        globalName: 'forge'
      }
    },
    component: () => import('../views/orders/createOrder')
  },
  {
    path: '/orderDetail',
    name: 'orderDetail',
    meta: {
      title: '订单详情',
      cdn: {
        url: 'https://misc.lkbang.net/common/clipboard/2.0.8/clipboard.min.js',
        globalName: 'ClipboardJS'
      }
    },
    component: () => import('../views/orderDetail')
  },
  {
    path: '/logisticsSelect',
    name: 'logisticsSelect',
    meta: {
      title: '物流公司'
    },
    component: () => import('../views/logistics/logisticsSelect')
  },
  {
    path: '/logisticsNum',
    name: 'logisticsNum',
    meta: {
      title: '填写物流单号',
      keepAlive: true
    },
    component: () => import('../views/logistics/logisticsNum')
  },
  {
    path: '/refundList',
    name: 'refundList',
    meta: {
      title: '退货/售后'
    },
    component: () => import('../views/refund/refundList')
  },
  {
    path: '/refundReason',
    name: 'refundReason',
    meta: {
      title: '七天无理由退换货规范 '
    },
    component: () => import('../views/refund/refundReason')
  },
  {
    path: '/refundDetail',
    name: 'refundDetail',
    meta: {
      title: '售后详情',
      cdn: {
        url: 'https://misc.lkbang.net/common/clipboard/2.0.8/clipboard.min.js',
        globalName: 'ClipboardJS'
      }
    },
    component: () => import('../views/refund/refundDetail')
  },
  {
    path: '/refundFreight/:id',
    name: 'refundFreight',
    meta: {
      title: '申请退运费',
      cdn: {
        url: 'https://misc.lkbang.net/common/qiniu-js/3.3.1/qiniu.min.js',
        globalName: 'qiniu'
      }
    },
    component: () => import('../views/refund/refundFreight')
  },
  {
    path: '/refundFreightSuccess',
    name: 'refundFreightSuccess',
    meta: {
      title: '申请退运费'
    },
    component: () => import('../views/refund/refundFreightSuccess')
  },
  {
    path: '/refund',
    name: 'refund',
    meta: {
      title: '我要退款',
      cdn: {
        url: 'https://misc.lkbang.net/common/qiniu-js/3.3.1/qiniu.min.js',
        globalName: 'qiniu'
      }
    },
    component: () => import('../views/refund/refund')
  },
  {
    path: '/refundKepler',
    name: 'refundKepler',
    meta: {
      title: '我要退款',
      cdn: {
        url: 'https://misc.lkbang.net/common/qiniu-js/3.3.1/qiniu.min.js',
        globalName: 'qiniu'
      }
    },
    component: () => import('../views/refund/refundKepler')
  },
  {
    path: '/refundType',
    name: 'refundType',
    meta: {
      title: '申请售后类型',
      keepAlive: true // 需要缓存
    },
    component: () => import('../views/refund/refundType')
  },
  {
    path: '/refundOnlyDetail',
    name: 'refundOnlyDetail',
    meta: {
      title: '售后详情',
      cdn: {
        url: 'https://misc.lkbang.net/common/clipboard/2.0.8/clipboard.min.js',
        globalName: 'ClipboardJS'
      }
    },
    component: () => import('../views/refund/refundOnlyDetail')
  },
  {
    path: '/refundConsultHistory/:serviceNo',
    name: 'refundConsultHistory',
    meta: {
      title: '协商历史'
    },
    component: () => import('../views/refund/refundConsultHistory')
  },

  {
    path: '/pay',
    name: 'pay',
    meta: {
      title: '收银台',
      cdn: [
        {
          url: 'https://misc.lkbang.net/common/crypto-js/3.1.9-1/crypto.min.js',
          globalName: 'CryptoJS'
        },
        {
          url: 'https://misc.lkbang.net/common/node-forge/0.10.0/forge.min.js',
          globalName: 'forge'
        }
      ]
    },
    component: () => import('../views/pay')
  },
  {
    path: '/payFail',
    name: 'payFail',
    // alias: ['/payFail'],
    meta: {
      title: '支付失败',
      smStatus: '1'
    },
    component: () => import('../views/pay/payResult')
  },
  {
    path: '/paySuccess',
    name: 'paySuccess',
    // alias: ['/paySuccess'],
    meta: {
      title: '支付成功',
      success: true,
      smStatus: '2'
    },
    component: () => import('../views/pay/payResult')
  },
  {
    path: '/payWaiting',
    name: 'payWaiting',
    meta: {
      title: '支付中',
      success: true
    },
    component: () => import('../views/pay/payWaiting')
  },
  {
    path: '/payWaitingAli',
    name: 'payWaitingAli',
    meta: {
      title: '支付中',
      success: true
    },
    component: () => import('../views/pay/payWaitingAli')
  },
  {
    path: '/activity/goodDetail',
    name: 'spikeDetail',
    component: () => import('../views/activity/spike/detail'),
    meta: { title: '商品详情' }
  },
  {
    path: '/activity/spike',
    name: 'activitySpike',
    component: () => import('../views/activity/spike'),
    meta: { title: '活动页', keepLive: true }
  },
  {
    path: '/activity/panicBuying',
    name: 'panicBuying',
    component: () => import('../views/activity/panicBuying'),
    meta: { title: '抢购页', keepLive: true }
  },
  {
    path: '/coupon',
    name: 'coupon',
    component: () => import('../views/coupon'),
    meta: { title: '优惠券' }
  },
  {
    path: '/giftCardList',
    name: 'giftCardList',
    component: () => import('../views/giftCardList'),
    meta: {
      title: '我的礼品卡',
      cdn: {
        url: 'https://misc.lkbang.net/common/clipboard/2.0.8/clipboard.min.js',
        globalName: 'ClipboardJS'
      }
    }
  },
  {
    path: '/snapshot',
    name: 'snapshot',
    component: () => import('../views/snapshot/index.vue'),
    meta: { title: '交易快照' }
  },
  {
    path: '/snapshotDetail',
    name: 'snapshotDetail',
    component: () => import('../views/snapshot/detail.vue'),
    meta: { title: '快照详情' }
  },
  {
    path: '/docking',
    name: 'docking',
    meta: {
      cdn: {
        url: 'https://misc.lkbang.net/common/node-forge/0.10.0/forge.min.js',
        globalName: 'forge'
      }
    },

    component: () => import('../views/docking')
  },
  {
    path: '/downloadsApp',
    name: 'downloadsApp',
    component: () => import('../views/downloadsApp')
  },
  {
    path: '/browseRecords',
    name: 'browseRecords',
    meta: {
      title: '浏览记录'
    },
    component: () => import('../views/browseRecords/index')
  },
  {
    path: '/browseSimilarity',
    name: 'browseSimilarity',
    meta: {
      title: '看相似'
    },
    component: () => import('../views/browseRecords/browseSimilarity')
  },
  {
    path: '/error',
    name: 'error',
    meta: {
      title: '出错了'
    },
    component: () => import('../components/error')
  },
  {
    path: '*',
    name: 'notFound',
    meta: {
      title: '找不到页面'
    },
    component: () => import('../components/error/NotFound')
  },
  {
    path: '/newPeopleArea',
    name: 'newPeopleArea',
    meta: {
      title: '新人福利专区'
    },
    component: () => import('../views/newPeopleArea/index')
  }
];
