import config from '@/config';
import http from '@/service/httpDecorator';
const { kdspHost } = config;
const strategy = {
  strategy: 'promotion'
};

export const promotionLogin = data => {
  // 地推工具登录
  return http.post(`${kdspHost}/api/kdsp/group/push/login`, data, strategy);
};

export const getGroupPushUserInfo = () => {
  return http.get(`${kdspHost}/api/kdsp/group/push/getGroupPushUserInfo`, strategy);
};

export const getJSuPackageDenominations = () => {
  // 获取套餐、礼品卡级联套餐
  return http.get(`${kdspHost}/api/kdsp/group/push/getJSuPackageDenominations`, strategy);
};

export const submit = data => {
  // 提交审核单
  return http.post(`${kdspHost}/api/kdsp/group/push/preCommitUserCard`, data, strategy);
};

export const getRecords = data => {
  return http.get(
    `${kdspHost}/api/kdsp/group/push/handlingRecords?pageNo=${data.pageNo}&pageSize=${data.pageSize}&auditStatus=${data.auditStatus}`,
    strategy
  );
};
