export const jverificationInit = function() {
  return new Promise(resolve => {
    console.log(window.JVerificationInterface);
    window.JVerificationInterface.init({
      appkey: '1f70875fc3941d8f1964eb63', // 极光官网中创建应用后分配的 appkey，必填
      debugMode: true, // 设置是否开启 debug 模式。true 则会打印更多的日志信息。设置 false 则只会输出 w、e 级别的日志
      fail: function(data) {
        resolve(data);
      },
      success: function(data) {
        resolve(data);
      }
    });
  });
};

export const isJverificationInitSuccess = function() {
  // 是否成功初始化
  var succ = window.JVerificationInterface.isInitSuccess();
  return succ;
};

// 获取运营商token
export const getJverificationToken = function() {
  return new Promise(resolve => {
    window.JVerificationInterface.getToken({
      success: function(data) {
        console.log(data, 'getTokenSuccess');
        resolve(data);
      },
      fail: function(data) {
        console.log(data, 'getTokenFailed');
        resolve(data);
      }
    });
  });
};

// 认证登录
export const jverificationLogin = function() {
  return new Promise(resolve => {
    window.JVerificationInterface.loginAuth({
      type: 'dialog', //可填全屏：full，弹窗：dialog，不填默认全屏
      fail: function(data) {
        console.log('JVerificationInterface loginAuth fail:' + JSON.stringify(data));
        resolve(data);
      },
      success: function(data) {
        var token = data.content;
        console.log('JVerificationInterface loginAuth success:' + token);
        resolve(data);
      }
    });
  });
};
