import store from '@/store';
export default {
  data() {
    return {
      prevRoute: ''
    };
  },
  // ! 注意：组件名称需要与route中的name一致，route中只支持驼峰
  beforeRouteEnter(to, from, next) {
    store.commit('ADD_KEEP_ALIVE', to.name);
    next(vm => {
      if (!vm.prevRoute) vm.prevRoute = from.name;
    });
  },
  beforeRouteLeave(to, from, next) {
    // this.prevRoute === to.name && store.commit('DEL_KEEP_ALIVE', from.name);
    next();
  }
};
