import config from '@/config';
import http from '@/service/httpDecorator';
import uiTrack from '@/service/sa.service';
const { yxmGwHost } = config;
// const talosApi = "http://yapi.quantgroups.com/mock/351";
const query = data => {
  return http.post(`${yxmGwHost}/api/kdsp/shop-cart/list/valid/v3`, data);
};
const goodSelected = data => {
  return http.post(`${yxmGwHost}/api/kdsp/shop-cart/selected`, data);
};
const goodAdd = data => {
  return http.post(`${yxmGwHost}/api/kdsp/shop-cart/add-update`, data);
};
const goodFee = data => {
  return http.post(`${yxmGwHost}/api/kdsp/shop-cart/fee/v3`, data);
};
const orderConfirm = data => {
  return http.post(`${yxmGwHost}/api/kdsp/shop-cart/order-confirm/page/v3`, data);
};
// 获取购物车商品数量
const getCartCount = () => {
  return http.get(
    `${yxmGwHost}/api/kdsp/shop-cart/count`,
    {},
    {
      // hideLoading: true
    }
  );
};

const shopCartLike = async function(data) {
  // return request.get(`${talosApi}/vcc/xyqb/jd/recommend/like`, data, {
  const scDeviceId = await uiTrack.run('saDeviceId');
  return http.get(`${yxmGwHost}/api/kdsp/recommend/goods-list`, {
    params: data,
    customHeader: { scDeviceId }
  });
};

// 无效商品列表
const getInvalidList = data => {
  return http.post(`${yxmGwHost}/api/kdsp/shop-cart/list/invalid`, data, {
    // hideLoading: true
    customHeader: {
      version: '8.9.00'
    }
  });
};

const addSkuToCart = data => {
  return http.post(`${yxmGwHost}/api/kdsp/shop-cart/add-update`, data, {
    // hideLoading: true
  });
};
const beforeConfirmCheck = function() {
  return http.post(`${yxmGwHost}/api/kdsp/shop-cart/before/order-confirm`);
};

// http://yapi.quantgroups.com/project/645/interface/api/62384
const changeActivity = params => {
  return http.post(`${yxmGwHost}/api/kdsp/shop-cart/selected-activity/change`, params);
};

export {
  query,
  goodSelected,
  goodAdd,
  goodFee,
  orderConfirm,
  getCartCount,
  shopCartLike,
  getInvalidList,
  addSkuToCart,
  beforeConfirmCheck,
  changeActivity
};
