import config from '@/config';
import http from '@/service/httpDecorator';
import uiTrack from '@/service/sa.service';

const { yxmGwHost, kdspHost } = config;

/**
 * 商品详情
 * http://yapi.quantgroups.com/project/645/interface/api/56554
 */
export const detailInfo = data => {
  return http.get(`${yxmGwHost}/api/kdsp/sku-info/detail/query/v2`, { params: data });
};
/**
 * 商品的活动和优惠券
 * http://yapi.quantgroups.com/project/645/interface/api/56564
 */
export const actAndCpn = data => {
  return http.post(`${yxmGwHost}/api/kdsp/sku-info/detail/actAndCpn`, data);
};

// 详情图片
export const getDetailPic = url => {
  return http.get(url, { strategy: 'default', hideLoading: 1, skip: 1, hideToast: 1 });
};

/**
 * 获取商品评价
 * http://yapi.quantgroups.com/project/645/interface/api/61869
 */
export const getCommentList = params => {
  return http.get(`${yxmGwHost}/api/kdsp/comment/sku-comment-info`, {
    params,
    hideLoading: 1
  });
};

export default {
  // 详情页-猜你喜欢
  async goodsLike(data) {
    const scDeviceId = await uiTrack.run('saDeviceId');
    return http.get(`${yxmGwHost}/api/kdsp/recommend/goods-detail/similarity`, {
      params: data,
      customHeader: {
        scDeviceId
      }
    });
  },
  // 门店信息
  shopDetail(shopId) {
    return http.get(`${kdspHost}/api/kdsp/store/detail/query?shopId=${shopId}`);
  },
  // 营业执照信息
  businessLicense(shopId) {
    return http.get(`${kdspHost}/api/kdsp/store/businessLicense?storeId=${shopId}`);
  }
};
