import config from '@/config';
import http from '@/service/httpDecorator';
import uiTrack from '@/service/sa.service';
import { dealSmDeviceId } from '@/service/shumei.service';
const { yxmGwHost } = config;

export const getCouponList = async params => {
  const scDeviceId = await uiTrack.run('saDeviceId');
  return http.get(`${yxmGwHost}/api/kdsp/coupon/user-coupons`, {
    params,
    customHeader: {
      scDeviceId
    }
  });
};

export const getGiftCardList = data => {
  return http.post(`${yxmGwHost}/api/kdsp/card/list`, data);
};

export const getGiftCardDetail = data => {
  console.log(data);
  return http.post(`${yxmGwHost}/api/kdsp/card/io`, data);
};

export const pickupCoupon = async data => {
  const smDeviceId = (await dealSmDeviceId()) || '';
  data.shumeiDeviceId = smDeviceId;
  return http.post(`${yxmGwHost}/api/kdsp/coupon/pickup-batch`, data);
};

export const pickupCouponBySkuNo = async data => {
  const smDeviceId = (await dealSmDeviceId()) || '';
  data.tongdunDeviceId = smDeviceId;
  return http.post(`${yxmGwHost}/api/kdsp/coupon/skuInfoPickup`, data);
};
