const fs = require('fs');
const path = require('path');

const defaultConfig = {
  "name" : "羊小咩plus",
  "appid" : "wxb3e6270e1b1e0bc7",
  "description" : "",
  "versionName" : "1.0.0",
  "versionCode" : "100",
  "transformPx" : false,
  "app-plus" : {
      "usingComponents" : true,
      "splashscreen" : {
          "alwaysShowBeforeRender" : true,
          "waiting" : true,
          "autoclose" : true,
          "delay" : 0
      },
      "modules" : {},
      "distribute" : {
          "android" : {
              "permissions" : [
                  "<uses-permission android:name=\"android.permission.CHANGE_NETWORK_STATE\"/>",
                  "<uses-permission android:name=\"android.permission.MOUNT_UNMOUNT_FILESYSTEMS\"/>",
                  "<uses-permission android:name=\"android.permission.READ_CONTACTS\"/>",
                  "<uses-permission android:name=\"android.permission.VIBRATE\"/>",
                  "<uses-permission android:name=\"android.permission.READ_LOGS\"/>",
                  "<uses-permission android:name=\"android.permission.ACCESS_WIFI_STATE\"/>",
                  "<uses-feature android:name=\"android.hardware.camera.autofocus\"/>",
                  "<uses-permission android:name=\"android.permission.WRITE_CONTACTS\"/>",
                  "<uses-permission android:name=\"android.permission.ACCESS_NETWORK_STATE\"/>",
                  "<uses-permission android:name=\"android.permission.CAMERA\"/>",
                  "<uses-permission android:name=\"android.permission.RECORD_AUDIO\"/>",
                  "<uses-permission android:name=\"android.permission.GET_ACCOUNTS\"/>",
                  "<uses-permission android:name=\"android.permission.MODIFY_AUDIO_SETTINGS\"/>",
                  "<uses-permission android:name=\"android.permission.READ_PHONE_STATE\"/>",
                  "<uses-permission android:name=\"android.permission.CHANGE_WIFI_STATE\"/>",
                  "<uses-permission android:name=\"android.permission.WAKE_LOCK\"/>",
                  "<uses-permission android:name=\"android.permission.CALL_PHONE\"/>",
                  "<uses-permission android:name=\"android.permission.FLASHLIGHT\"/>",
                  "<uses-permission android:name=\"android.permission.ACCESS_COARSE_LOCATION\"/>",
                  "<uses-feature android:name=\"android.hardware.camera\"/>",
                  "<uses-permission android:name=\"android.permission.ACCESS_FINE_LOCATION\"/>",
                  "<uses-permission android:name=\"android.permission.WRITE_SETTINGS\"/>"
              ]
          },
          "ios" : {},
          "sdkConfigs" : {}
      }
  },
  "quickapp" : {},
  "mp-weixin" : {
      "appid" : "wxb3e6270e1b1e0bc7",
      "setting" : {
          "urlCheck" : true,
          "postcss" : true,
          "minified" : true
      },
      "usingComponents" : true,
      "optimization": {
        "subPackages": true
      },
      "permission" : {
        "scope.userLocation" : {
            "desc" : "授权位置，为您提供更好的服务"
        }
      },
      "requiredPrivateInfos" : [ "getLocation"],
  },
  "mp-alipay" : {
      "usingComponents" : true,
      "appid": "2021003126632272",
      "enableAppxNg": true
  },
  "mp-baidu" : {
      "usingComponents" : true,
      "appid": "25998612",
      "optimization": {
        "subPackages": true
      }
  },
  "mp-toutiao" : {
      "usingComponents" : true
  },
  "mp-qq" : {
      "usingComponents" : true
  }
}

const createManifestConfig = function(name = '', appId = '', mp = "mp-weixin") {
  const config = Object.assign(defaultConfig, {});
  if (name) {
    config.name = name;
  }
  if (appId) {
    config.appid = appId;
    config[mp].appid = appId;
  }
  const configStr = JSON.stringify(config);
  const filePath = path.resolve(process.cwd(), './src/manifest.json');
  try {
    fs.statSync(filePath).isFile();
  } catch (err) {
    fs.appendFileSync(filePath, configStr);
  }
  fs.writeFileSync(filePath, configStr, {});
}

module.exports = {
  createManifestConfig
}
