import Vue from 'vue';
import { init as sentryInit } from '@sentry/vue';
import App from './App.vue';
import router from './router';
import store from './store';
import Bridge from '@qg/js-bridge';
// import '@/service/svg.service';
import { shuMeiInit, getSmDeviceId } from '@/service/shumei.service';
import '@/service/cherryUI.service';
import './style/index.less';
import '@/assets/svg/index';
import './style/operator.less';
import saService from '@/service/sa.service';
import lazyload from '@qg/cherry-ui/src/lazyload/index';
import { getToKen } from '@/service/userInfo.service';
import { imgMogrVue, checkWebp } from '@/filters/img2Thumb.filter';
import { replaceFavicon } from '@/service/utils.service';
import { getPublicConfig } from '@/customize';
const publicConfig = getPublicConfig();

Vue.prototype.$track = saService;
Vue.prototype.$config = publicConfig;
Vue.prototype.$bridge = new Bridge();
Vue.use(lazyload);
Vue.use(imgMogrVue);

getToKen();

Vue.config.productionTip = false;

replaceFavicon(publicConfig.faviconPath);
// eslint-disable-next-line prettier/prettier
(async () => {
  await checkWebp();
  shuMeiInit();
  getSmDeviceId();
  // console.log(getSmDeviceId);
})();
if (process.env.SENTRY_ENV !== 'test' && process.env.NODE_ENV === 'production') {
  sentryInit({
    Vue,
    attachProps: true, // 允许Sentry上报Vue组件Props
    logErrors: true, // 引入Sentry SDK后，默认不会将报错打印到控制台，将logErrors设为true强制将报错打印到控制台
    dsn: 'https://0810381ba85d4b2788ddafa29078851c@sentry.q-gp.com/4',
    release: 'bmall-ui@1.0.0',
    tracesSampleRate: 0.5, // 上报频率, 1最大, 0最小, 建议验证设置为1, 项目运行根据情况降低频率
    environment: process.env.NODE_ENV
  });
}
new Vue({
  router,
  store,
  render: h => h(App)
}).$mount('#app');
