/* eslint-disable space-before-function-paren */
/* eslint-disable prettier/prettier */
import request from '@/service/httpDecorator';
import config from '@/config';
import uiTrack from '@/service/sa.service';
const { yxmGwHost } = config;
// import { getPublicConfig } from '@/customize';
// const publicConfig = getPublicConfig();

const queryPayInfo = function(data) {
  return request.post(`${yxmGwHost}/open/checkout/v2/checkout`, data);
};
const prepay = async function(data) {
  const scDeviceId = await uiTrack.run('saDeviceId');
  // const url = publicConfig.xincheng ? '/open/checkout/v2/prepay' : '/open/checkout/prepay';
  const url = '/open/checkout/v2/prepay';
  return request.post(`${yxmGwHost}${url}`, data, {
    customHeader: {
      scDeviceId
    },
    hideToast: true
  });
};

const pay = async function(data) {
  const scDeviceId = await uiTrack.run('saDeviceId');
  // const url = publicConfig.xincheng ? '/open/checkout/v2/pay' : '/open/checkout/pay';
  const url = '/open/checkout/v2/pay';
  return request.post(`${yxmGwHost}${url}`, data, {
    customHeader: {
      scDeviceId
    },
    // 2022-11-04：不知道为啥要隐藏toast，现在有报错了，但是看不到，先注释掉了
    hideToast: false
  });
};

const queryPayStatus = function(data) {
  // const url = publicConfig.xincheng
  //   ? '/open/checkout/v2/pay_status/query'
  //   : '/open/checkout/pay_status/query';
  const url = '/open/checkout/v2/pay_status/query';
  return request.post(`${yxmGwHost}${url}`, data);
};

const sendSms = function(data) {
  return request.post(`${yxmGwHost}/open/checkout/send_sms`, data);
};

const desSalt = function() {
  return request.get(`${yxmGwHost}/vcc/account/salt`);
};

const h5AppyUrl = function() {
  return request.get(`${yxmGwHost}/vcc/xyqb_mall/app_url`);
};

const getCoupon = async function(params) {
  const scDeviceId = await uiTrack.run('saDeviceId');
  return request.post(`${yxmGwHost}/open/checkout/pay_coupon_list`, params, {
    customHeader: {
      scDeviceId
    }
  });
};

const ocrFaceId = function(params) {
  return request.post(`${yxmGwHost}/open/checkout/ocr_faceId`, params);
};

/**
 * feed流
 * http://yapi.quantgroups.com/project/351/interface/api/24939
 */
const getGoodsList = async function(data) {
  const scDeviceId = await uiTrack.run('saDeviceId');
  return request.get(`${yxmGwHost}/api/kdsp/recommend/goods-list`, {
    params: data,
    hideLoading: true,
    customHeader: {
      scDeviceId
    }
  });
};

// KA流程节点
const kaGetNextUrl = function() {
  return request.get(`${yxmGwHost}/api/kdsp/ka/process/get-next-url`);
};

const reissueContract = function(params) {
  return request.post(`${yxmGwHost}/open/checkout/payReissueContract`, params);
};

export default {
  // 商品详情页面
  desSalt() {
    return request.get(`${yxmGwHost}/vcc/account/salt`);
  }
};
/**
 * 获取支付结果信息
 * http://yapi.quantgroups.com/project/351/interface/api/25576
 */
const getResultInfo = function(params) {
  return request.get(`${yxmGwHost}/api/kdsp/appconfig/pay-succ-page/guide-stream`, { params });
};
/**
 * 根据支付状态获取按钮
 * http://yapi.quantgroups.com/project/645/interface/api/57314
 */
const getPayResultBtn = function(params) {
  return request.post(`${yxmGwHost}/api/kdsp/appconfig/pay_result/button`, params);
};

export {
  pay,
  prepay,
  sendSms,
  desSalt,
  h5AppyUrl,
  getCoupon,
  ocrFaceId,
  queryPayInfo,
  getGoodsList,
  kaGetNextUrl,
  getResultInfo,
  getPayResultBtn,
  queryPayStatus,
  reissueContract
};
