export default {
  data() {
    return {
      account: ''
    };
  },
  mounted() {
    if (this.$bridge.isApp) {
      this.$bridge.getToken();
      // 全局app登录态监听
      window.xyqbNativeEvent = res => {
        const json = typeof res === 'string' ? JSON.parse(res) : res;
        if (json?.event === 'getTokenSuccess') {
          this.account = json?.data?.phone;
        }
      };
    }
  },
  methods: {
    goCustomer() {
      const account = this.account;
      const customerLink = `https://kefu.q-gp.com/H5/#/chat?skillGroupId=398&enterpriseId=216&headline=%E7%BE%8A%E5%B0%8F%E5%92%A9%E5%95%86%E5%9F%8E&tel=400-666-0873&account=${account}`;
      this.$bridge.openNewUrl({
        data: {
          newUrl: customerLink
        }
      });
    }
  }
};
