import cookies from '@/service/cookieStorage.service';
import config from '@/config';
import localStorageService from '@/service/localStorage.service';
import { getVccChannel } from '@/service/userInfo.service';
import {
  creditStatus,
  IS_GROUP_PAY,
  IS_CREDIT_PAY,
  ACCOUNT_APPLY_FAIL,
  CREDIT_PAY,
  BOE_PAY,
  IS_VCC_PAY,
  CASH_PAY
} from './STATIC_DATA';
export const goUrlExtends = {
  methods: {
    goHome(payStatus) {
      // 商城地址
      if (payStatus) {
        this.$track?.registeredEvents('h5_RechargeResultPageClick', {
          pay_status: payStatus,
          buttons_name: '返回首页'
        });
      }
      setTimeout(() => {
        this.$router.replace({ name: 'Home' });
      }, 500);
    },
    goOrderList(payStatus) {
      if (payStatus) {
        this.$track?.registeredEvents('h5_RechargeResultPageClick', {
          pay_status: payStatus,
          buttons_name: '查看订单'
        });
      }
      setTimeout(() => {
        this.$router.replace({ name: 'orderList', params: { state: 0 } });
      }, 500);
    },
    goMemberCenter(payStatus) {
      if (payStatus) {
        this.$track?.registeredEvents('h5_RechargeResultPageClick', {
          pay_status: payStatus,
          buttons_name: '查看钻石会员'
        });
      }
      const vccToken = this.$route.query.vccToken || localStorageService.get('vccToken');
      const vccChannel = getVccChannel('vccChannel');
      setTimeout(() => {
        window.location.replace(
          `${config.vipHost}/memberCenter?vccToken=${vccToken}&vccChannel=${vccChannel}`
        );
      }, 100);
    },
    goMaxMember(payStatus) {
      if (payStatus) {
        this.$track?.registeredEvents('h5_RechargeResultPageClick', {
          pay_status: payStatus,
          buttons_name: '查看MAX会员'
        });
      }
      const vccToken = this.$route.query.vccToken || localStorageService.get('vccToken');
      const vccChannel = getVccChannel('vccChannel');
      setTimeout(() => {
        window.location.replace(
          `${config.vipHost}/maxMember?vccToken=${vccToken}&vccChannel=${vccChannel}`
        );
      }, 100);
    },
    goOrderDetail() {
      const orderNo = cookies.get('orderNo')?.orderNo;
      this.$router.push({
        name: 'orderDetail',
        query: { orderNo }
      });
    },
    showDialog(obj = {}) {
      const defaultParams = {
        message: '抱歉，您本月消费额度已用光，你可以选择其他支付方式',
        confirmButtonText: '其它支付方式',
        showCancelButton: false,
        confirmButtonColor: '#EC1500',
        cancelButtonColor: '#323232'
      };
      this.$dialog(Object.assign({}, defaultParams, obj));
    },
    statusCase(type) {
      const that = this;
      return new Promise((resolve, reject) => {
        const payMap = {
          // 没有信用支付信息时 显示该弹窗
          none: () => {
            this.showDialog({
              message: '请选择支付方式',
              confirmButtonText: '确定'
            });
            reject(false);
          },
          // 使用享花卡支付 但消费额度不够 显示该弹窗
          credit: () => {
            this.showDialog();
            reject(false);
          },
          // 使用渤e贷支付 但消费额度不够 显示该弹窗
          bo: () => {
            this.showDialog();
            reject(false);
          },
          // 使用享花卡支付 可用额度不够（抱歉, 您的本笔订单暂不支持享花卡支付, 请您使用其他支付方式~）
          noenough: () => {
            this.showDialog();
            reject(false);
          },
          // 使用享花卡支付 但有未完成支付的订单占用额度 显示该弹窗
          freeze: () => {
            this.showDialog({
              message: '您有未完成支付的订单占用额度，需要先支付完成该笔订单哦！',
              confirmButtonText: '查看订单',
              showCancelButton: true,
              cancelButtonText: '继续支付',
              onConfirm() {
                that.goOrderList();
                reject(false);
              },
              onCancel() {
                resolve(true);
              }
            });
          },
          // 使用享花卡支付 但未绑定银行卡 显示该弹窗
          notbank: () => {
            this.showDialog({
              message: '检测到您享花卡未绑定银行卡，请您先绑定银行卡，再使用吧～',
              confirmButtonText: '立即绑卡',
              showCancelButton: true,
              cancelButtonText: '其它支付方式',
              onConfirm() {
                const url = that.creditPayInfo.bindBankCardInfo.bindBankCardUrl;
                window.location.href = `${url}&returnUrl=${window.location.origin}/pay&from=pay`;
                reject(false);
              }
            });
          },
          // 使用第三方支付时 判断可使用享花卡支付（但未开通） 显示该弹窗
          openCredit: () => {
            this.showDialog({
              message: that.creditPayInfo.creditPayOpenDesc,
              confirmButtonText: '立即开通',
              cancelButtonText: '继续支付',
              showCancelButton: true,
              onConfirm() {
                that.goApply();
                reject(false);
              },
              onCancel() {
                resolve(true);
              }
            });
          },
          // 使用第三方支付时 判断可使用享花卡组合支付 显示该弹窗
          useGroup: () => {
            // 使用第三方支付时 判断可使用享花卡组合支付 显示该弹窗
            this.showDialog({
              message: '使用组合支付部分金额可免息使用40天哦！',
              confirmButtonText: '组合支付',
              cancelButtonText: '继续支付',
              showCancelButton: true,
              onConfirm() {
                for (let m of that.payMethods) {
                  if (IS_GROUP_PAY(m.method)) {
                    that.changePayType(m.method, m.mergePayPretreatmentInfo);
                    break;
                  }
                }
                reject(false);
              },
              onCancel() {
                resolve(true);
              }
            });
          },
          // 使用第三方支付时 判断可使用已开通的享花卡 显示该弹窗
          useCredit: () => {
            this.showDialog({
              message: '使用享花卡支付可免息使用40天哦！',
              confirmButtonText: '享花卡支付',
              cancelButtonText: '继续支付',
              showCancelButton: true,
              onConfirm() {
                that.changePayType(1);
                reject(false);
              },
              onCancel() {
                resolve(true);
              }
            });
          }
        };
        payMap[type]();
      });
    },
    /** tips
     * description 描述
     * url	跳转链接(继续完善)
     * guide	1：强引导2：弱引导
     */
    checkJinmeixinStatus(tips) {
      const that = this;
      const params = {
        message: tips.description,
        confirmButtonText: '立即完善',
        showCancelButton: true,
        onConfirm() {
          window.location.href = tips.url;
        }
      };
      if (tips.guide === 1) {
        params.cancelButtonText = '取消完善';
      } else {
        params.cancelButtonText = '继续支付';
        params.onCancel = () => {
          that.pay({
            flowOrderNo: that.flowOrderNo,
            guide: tips.guide
          });
        };
      }
      this.showDialog(params);
    },
    async onCheckStatusAndTrip() {
      const info = this.creditPayInfo;
      const checkCreditPayStatusArr = [
        // 没有信用支付信息时 显示该弹窗
        [() => !info, () => this.statusCase('none')],
        // 使用享花卡支付 但消费额度不够 显示该弹窗
        [
          () => IS_VCC_PAY(+this.payType) && this.payType === CREDIT_PAY && this.canUseAmount < 0,
          () => this.showDialog('credit')
        ],
        // 使用渤e贷支付 但消费额度不够 显示该弹窗
        [
          () => +this.payType === +BOE_PAY && +info.canAmt < +this.paymentInfo.orderAmt,
          () => this.showDialog('bo')
        ],
        // 使用享花卡支付 可用额度不够（抱歉, 您的本笔订单暂不支持享花卡支付, 请您使用其他支付方式~）
        [
          () => IS_VCC_PAY(+this.payType) && +info.orderCanUseAmt === 0 && info.riskLimitWindowDesc,
          () => this.showDialog('noenough')
        ],
        // 使用享花卡支付 但有未完成支付的订单占用额度 显示该弹窗
        [
          () => IS_VCC_PAY(+this.payType) && info.isFreezeCreditInOtherOrder,
          () => this.showDialog('freeze')
        ],
        // 使用享花卡支付 但未绑定银行卡 显示该弹窗
        [
          () => IS_VCC_PAY(+this.payType) && !info.bindBankCardInfo?.isBindBankCard,
          () => this.showDialog('notbank')
        ]
      ];
      // 使用第三方支付
      const checkThirdPayStatusArr = [
        // 使用第三方支付时 判断可使用享花卡支付（但未开通） 显示该弹窗
        [
          () =>
            creditStatus.indexOf(info.accountStatus) > -1 ||
            info.accountStatus === ACCOUNT_APPLY_FAIL,
          () => this.statusCase('openCredit')
        ],
        // 使用第三方支付时 判断可使用享花卡组合支付 显示该弹窗
        [() => this.creditPayList.isGroupPay, () => this.statusCase('useGroup')],
        // 使用第三方支付时 判断可使用已开通的享花卡 显示该弹窗
        [
          () =>
            Object.keys(this.creditPayList.payList).length &&
            Object.prototype.hasOwnProperty.call(this.creditPayList.payList, 'creditPayInfo'),
          () => this.statusCase('useCredit')
        ]
      ];

      let res = true;
      // 使用信用支付 : 使用第三方支付（微信、支付宝）
      let arr = [];
      if (IS_CREDIT_PAY(this.payType)) {
        // 如果选择信用支付 判断状态
        arr = checkCreditPayStatusArr;
      } else if (
        this.creditPayInfo &&
        +this.creditPayInfo.payMethod === 1 &&
        this.payType !== CASH_PAY
      ) {
        // 如果选择第三方支付 并且不为现金支付 且有享花卡的情况 展示享花卡挽留弹窗
        arr = checkThirdPayStatusArr;
      }
      for (let p of arr) {
        if (p[0]()) {
          res = await p[1]();
          break;
        }
      }
      return res;
    }
  }
};
