/*
 * @Description: 小程序 H5 SDK 方法mixins
 * @Date: 2021-05-12 21:00:45
 * @LastEditors: gzw
 * @LastEditTime: 2021-10-13 16:28:37
 */
import { param } from "@/utils/index";
import { h5Mixin } from "@/utils/h5Mixin";
export default {
  mixins: [h5Mixin()],
  data() {
    return {
      shareInfo: {}
    };
  },
  methods: {
    navBack() {
      setTimeout(() => {
        uni.navigateBack();
      }, 500);
    },
    getToken(option) {
      if (option.clear) {
        uni.removeStorageSync("token");
      }
      let query = param(option, true);
      uni.navigateTo({
        url: "/pages/user/login" + query
      });
    },
    shopCarAddGoodsNotification() {
      this.navBack();
    },
    openVccPage() {
      if (uni.getStorageSync("token")) {
        this.goApply();
      } else {
        uni.showToast({
          title: "请登录后操作",
          duration: 1500,
          complete: () => {
            uni.switchTab({
              url: "/pages/user/user"
            });
          }
        });
      }
    },
    showShareView(data) {
      this.shareInfo = data.shareDic;
    }
  }
};
