import { queryStringify } from '@/service/utils.service';
import localStorageService from '@/service/localStorage.service';
export default {
  methods: {
    jumpAppUrl(routeUrl, params = {}, replace = false) {
      const queryParams = queryStringify(params);
      const vccToken = this.$route.query.vccToken || localStorageService.get('vccToken');
      let successUrl = `${routeUrl}?vccToken=${vccToken}`;
      if (queryParams.length) {
        successUrl += `&${queryParams}`;
      }
      // if (this.$bridge.isApp) {
      //   const url = `${window.location.origin}${successUrl}`;
      //   this.$bridge.openNewUrl({
      //     data: {
      //       newUrl: url
      //     }
      //   });
      // } else {
      if (replace) {
        this.$router.replace(successUrl);
      } else {
        this.$router.push(successUrl);
      }
      // }
    },

    openAppUrl(routeUrl, params = {}) {
      const queryParams = queryStringify(params);
      const vccToken = this.$route.query.vccToken || localStorageService.get('vccToken');
      let successUrl = `${routeUrl}?vccToken=${vccToken}`;
      if (queryParams.length) {
        successUrl += `&${queryParams}`;
      }
      if (this.$bridge.isApp) {
        const url = `${window.location.origin}${successUrl}`;
        this.$bridge.openNewUrl({
          data: {
            newUrl: url
          }
        });
      } else {
        this.jumpAppUrl(routeUrl, params);
      }
    },
    closeApp() {
      if (this.$bridge.isApp) {
        this.$bridge.closeBrowser();
      } else {
        this.backRoute();
      }
    },
    backRoute() {
      // if (this.$bridge.isApp) {
      //   this.$bridge.closeBrowser();
      // } else {
      this.$router.go(-1);
      // }
    }
  }
};
