import http from '@/service/httpDecorator';
import config from '@/config';
const { yxmGwHost, faceHost, kdspHost } = config;
import { getPublicConfig } from '@/customize';
const publicConfig = getPublicConfig();

export default {
  // 获取信用钱包用户信息
  getXhkInfo() {
    return http.get(`${yxmGwHost}/api/kdsp/profile/vcc/user-account`);
  },
  getUserInfo() {
    return http.get(`${yxmGwHost}/api/kdsp/user/about`);
  }
};

// 发送短信
export const smsCode = param => {
  if (publicConfig.qinghai) {
    const { phoneNo, captchaId, captchaValue } = param;
    return http.post(
      `${kdspHost}/ex/kdsp/jfsd/user/sendSms?phoneNo=${phoneNo}&captchaValue=${captchaValue}&captchaId=${captchaId}`
    );
  }
  const data = { ...param, smsMerchant: 'XIN_YONG_QIAN_BAO' };
  return http.post(`${yxmGwHost}/vcc/usercenter/send_vcc_sms_code`, data);
};

// KA流程节点
export const kaGetNextUrl = params => {
  let options = {
    sonVccChannel: true
  };
  return http.get(`${yxmGwHost}/api/kdsp/ka/process/get-next-url`, { params }, options);
};
// 验证短信并登录
export const friendLogin = data => {
  if (publicConfig.qinghai) {
    const { loginName, smsCode } = data;
    return http.post(`${kdspHost}/ex/kdsp/jfsd/user/login?phoneNo=${loginName}&smsCode=${smsCode}`);
  }
  return http.post(`${yxmGwHost}/vcc/usercenter/fast_login_by_sms_code`, data, {
    timeout: 60 * 2 * 1000
  });
};
export const loginByPassword = data => {
  return http.post(`${yxmGwHost}/vcc/usercenter/login_by_pwd`, data);
};

// 验证短信类型
export const captchaType = data => {
  return http.post(`${yxmGwHost}/vcc/usercenter/captcha_type`, data);
};

// 获取图形验证
export const captcha = () => {
  if (publicConfig.qinghai) {
    return http.post(`${kdspHost}/ex/kdsp/jfsd/user/captcha`);
  }
  return http.get(`${yxmGwHost}/vcc/usercenter/qg_captcha`);
};

export const getFaceUrl = params => {
  return http.get(`${faceHost}/auth-center/ex/face/h5/auth_url.json`, { params });
};

// 安硕demo项目暂时这么处理
export const getDemoToken = params => {
  const { phoneNo, vccChannel } = params;
  return http.get(`${kdspHost}/ex/kdsp/${vccChannel}/anShuo/quick_login`, {
    params: { phoneNo }
  });
};

// 青海获取礼品卡余额接口
export const getGiftCard = () => {
  return http.get(`${yxmGwHost}/api/kdsp/user/card-coupon`);
};

export const logout = () => {
  return http.get(`${kdspHost}/api/kdsp/logout/user`);
};
export const myWallet = params => {
  return http.get(`${kdspHost}/api/kdsp/user/mine/my-wallet`, {
    params
  });
};
export const getContract = () => {
  return http.get(`${kdspHost}/api/kdsp/contract/view`);
};

export const smEvent = data => {
  return http.post(`${kdspHost}/api/kdsp/shumei/eventDataServer/report`, data);
};

export const uploadSMIDToKdsp = data => {
  return http.post(`${kdspHost}/api/kdsp/fraud/borderColor`, data);
};

// 一键登录
export const oneKeyLogin = data => {
  return http.post(`${kdspHost}/api/kdsp/user/login/oneKeyLogin`, data);
  // return http.post(`${kdspHost}/api/kdsp/user/login/oneKeyLogin`, data);
  // https://sappbackend-yxm2.liangkebang.net/auth/one-login
};
// 新人登录后跳转到新人页
export const apiLoginSuccessPage = () => {
  return http.get(`${yxmGwHost}/api/kdsp/user/loginSuccessPage`);
};

// 我的页面
export const mineInfo = data => {
  return http.post(`${kdspHost}/api/kdsp/user/v2/mine-info`, data);
};
