// import api from '@/api/receipts.js';
export default {
  data() {
    return {
      checkAll: false,
      loading: false
    };
  },
  computed: {
    allPrice() {
      const sumPrice = this.orders.reduce((sum, item) => {
        if (item.checked) sum += +item.invoiceTotalFee;
        return sum;
      }, 0);
      return sumPrice.toFixed(2);
    },
    btnDisabled() {
      const disabled = this.orders.some(item => item.checked);
      return !disabled;
    },
    checkDisabled() {
      return this.orders.length === 0;
    }
  },
  methods: {
    checkAllOptions() {
      if (this.checkAll) {
        this.orders.forEach(item => {
          if (!item.disabled) {
            item.checked = true;
          }
        });
        return;
      }
      const nChecked = !this.orders.some(item => {
        if (!item.disabled) {
          return !item.checked;
        }
      });
      if (nChecked) {
        this.orders.forEach(item => (item.checked = false));
      }
    },
    changeChecked() {
      this.checkAll = !this.orders.some(item => {
        if (!item.disabled) {
          return !item.checked;
        }
      });
    },
    // 获取选中不通状态下订单号
    getCheckedItems() {
      // 全部选中订单号 // 选中内-合并订单号 // 单独订单号
      const originData = { orderNos: [], mergeNos: [], aloneNos: [], mergeSum: 0 };
      return this.orders.reduce((origin, item) => {
        if (item.checked) {
          // 是否可以合并开票
          if (item.canCombineInvoice) {
            origin.mergeNos.push(item.orderNo);
            origin.mergeSum += item.invoiceTotalFee * 1;
          } else {
            origin.aloneNos.push(item.orderNo);
          }
          origin.orderNos.push(item.orderNo);
        }
        return origin;
      }, originData);
    },
    redText(msg, bold = 'bold') {
      return `<span style="color: #ee0a24; font-weight: ${bold};">${msg}</span>`;
    },

    showMergeMsgDialog() {
      const orderNoItem = this.getCheckedItems();
      // console.log(orderNoItem);
      const { orderNos, aloneNos, mergeNos, mergeSum } = orderNoItem;
      const allMerge = +mergeSum >= 100000;
      const msgTemp = [
        `<h3 style="font-weight: bold;">您已勾选 ${this.redText(orderNos.length)} 笔订单：</h3>`
      ];
      if (aloneNos.length) {
        msgTemp.push(`${this.redText(aloneNos.length)} 笔订单为单独开票、`);
      }
      if (mergeNos.length) {
        msgTemp.push(`${this.redText(mergeNos.length)} 笔支持合并开票；`);
      }
      msgTemp.push(`本次开票金额为 ${this.redText(this.allPrice)} 元；`);
      if (allMerge) {
        msgTemp.push(
          `<br /><br /><h3>合并开票订单超出10万元暂不支持开具电子发票，如您需要可联系客服</h3>`
        );
      } else {
        msgTemp.push(
          `<br /><br /><h3>发票开具后${this.redText('不可撤销', '400')}请仔细核对。</h3>`
        );
      }

      this.$dialog({
        title: '温馨提示',
        customClass: 'cr-dialog-invoice',
        messageAlign: 'left',
        closeable: true,
        closeOnClickOverlay: false,
        message: `<div style="color: #666666;">${msgTemp.join('')}</div>`, //`是否将所选订单开具成一张发票？发票开具后<span style="color: #ee0a24;">不可撤销</span>，请仔细核对！`,
        showConfirmButton: Boolean(mergeNos.length),
        confirmButtonText: allMerge ? '全部单独开票' : '合并开票',
        cancelButtonText: allMerge ? '联系客服' : '全部单独开票',
        cancelButtonColor: mergeNos.length ? '#333333' : '#ec1500',
        onConfirm: () => {
          if (allMerge) {
            this.onSure([], orderNos); // 全部单独开票
          } else {
            this.onSure(mergeNos, aloneNos); // 合并开票
          }
        },
        onCancel: () => {
          if (allMerge) {
            this.goCustomer();
          } else {
            this.onSure([], orderNos); // 全部单独开票
          }
        }
      });
    },
    async onSure(orderNosCombine, orderNosSingle) {
      this.jumpAppUrl('/electronicReceipt/invoiceReceipt', {
        orderNosCombine: orderNosCombine.join(),
        orderNosSingle: orderNosSingle.join()
      });
    },
    showCheckZeroDialog(message) {
      this.$dialog({
        customClass: 'cr-dialog-invoice',
        closeOnClickOverlay: true,
        message,
        confirmButtonText: '重新勾选',
        cancelButtonText: '联系客服',
        cancelButtonColor: '#333333',
        onCancel: () => {
          this.goCustomer();
        }
      });
    }
  }
};
