import http from '@/service/httpDecorator';
import config from '@/config';
const { yxmGwHost } = config;

export const getBrowseList = data => {
  return http.post(`${yxmGwHost}/api/kdsp/browse/list`, data);
};

export const delBrowseList = data => {
  return http.post(`${yxmGwHost}/api/kdsp/browse/delete`, { ids: data });
};

export const getBrowseCalendar = () => {
  return http.post(`${yxmGwHost}/api/kdsp/browse/get-calendar`);
};

export const getGoodsList = data => {
  return http.post(`${yxmGwHost}/api/kdsp/search/simple-result`, data);
};

// 订阅商品
export const subscribeAdd = data => {
  return http.post(`${yxmGwHost}/api/kdsp/subscribe/add`, data);
};

// 查询商品详情简单参数
export const basicSkuInfoQuery = skuNo => {
  return http.get(`${yxmGwHost}/api/kdsp/sku-info/basic-sku-Info/query`, {
    params: { skuNo }
  });
};

export const browseDeleteAll = () => {
  return http.post(`${yxmGwHost}/api/kdsp/browse/delete-all`);
};

// http://yapi.quantgroups.com/mock/351/api/kdsp/browse/delete
