import config from '@/config';
import http from '@/service/httpDecorator';
const { yxmGwHost } = config;

export default {
  // 订单列表
  orderList(data) {
    return http.get(`${yxmGwHost}/api/kdsp/order-info/list/query`, { params: data });
  },
  // 申请退款 是否签合同
  queryNote(data) {
    return http.get(`${yxmGwHost}/api/kdsp/order-info/queryNote`, { params: data });
  },
  // 用户订单确认收货接口
  orderConfirm(data) {
    return http.post(`${yxmGwHost}/api/kdsp/order-info/receipt/confirm`, data);
  },
  // 用户订单取消接口【未付款】
  orderCancel(data) {
    return http.post(`${yxmGwHost}/api/kdsp/order-info/cancel`, data);
  },
  // 用户订单取消接口【未发货】
  orderUnfilledCancel(data) {
    return http.get(`${yxmGwHost}/api/kdsp/order-info/unfilled/cancel`, { params: data });
  },
  // 用户订单取消接口【未发货】
  orderUnfilledCancelV2(data) {
    return http.get(`${yxmGwHost}/api/kdsp/order-info/unfilled/cancel/v2`, { params: data });
  },
  // 订单取消原因查询接口
  orderCancelReason(params) {
    return http.get(`${yxmGwHost}/api/kdsp/order-info/cancel-reason/query`, { params });
  },
  // 订单取消原因查询接口
  orderCancelReasonV2(data) {
    return http.get(`${yxmGwHost}/api/kdsp/order-info/paid-cancel-props/query`, { params: data });
  },
  // 订单详情查询接口
  orderDetail(data) {
    return http.get(`${yxmGwHost}/api/kdsp/order-info/detail/query`, { params: data });
  },
  // 物流详情查询接口
  expressDetail(data) {
    // return http.get('http://yapi.quantgroups.com/mock/351/api/kdsp/logistics/packages-list');
    return http.get(`${yxmGwHost}/api/kdsp/logistics/packages-list`, { params: data });
  },
  // 我的 查询各状态订单数量
  orderInfo() {
    return http.get(`${yxmGwHost}/api/kdsp/order-info/status-number`);
  },
  confirmOrder(data) {
    return http.post(`${yxmGwHost}/api/kdsp/shop-cart/order-confirm/page/v3`, data);
  },

  // todo 8.8.90 开始接口升级
  orderSubmit(data) {
    return http.post(`${yxmGwHost}/api/kdsp/order-info/e/submit`, data, {
      customHeader: {
        version: '8.8.00'
      }
    });
  },
  // 物流公司列表
  companyList() {
    return http.get(`${yxmGwHost}/api/kdsp/logistics/kd100/company-list`);
  },
  // 物流公司列表
  getCompany(data) {
    return http.get(`${yxmGwHost}/api/kdsp/logistics/kd100/`, { params: data });
  },
  // 售后原因查询
  applyReason(data) {
    return http.get(`${yxmGwHost}/api/kdsp/after-service/apply-reason`, { params: data });
  },
  // 售后原因查询V2
  applyReasonV2(data) {
    return http.get(`${yxmGwHost}/api/kdsp/after-service/v2/apply-reason`, { params: data });
  },
  // 售后退款金额试算
  refundAmount(data) {
    return http.get(`${yxmGwHost}/api/kdsp/after-service/refund-amount`, { params: data });
  },
  getOrderSkuDetail(data) {
    return http.get(`${yxmGwHost}/api/kdsp/order-sku/detail/query`, { params: data });
  },
  // 填写售后信息页面的查询接口
  applyPageInfo(data) {
    return http.get(`${yxmGwHost}/api/kdsp/after-service/apply-page-info`, { params: data });
  },
  // 填写售后信息页面的查询v2接口
  applyPageInfoV2(data) {
    return http.get(`${yxmGwHost}/api/kdsp/after-service/v2/apply-page-info`, { params: data });
  },
  // 提交申请售后
  applySubmit(data) {
    return http.post(`${yxmGwHost}/api/kdsp/after-service/apply`, data);
  },
  afterV2Detail(data) {
    return http.get(`${yxmGwHost}/api/kdsp/after-service/v2/detail`, { params: data });
  },
  // 订单申请退款
  refundKepler(data) {
    return http.post(`${yxmGwHost}/api/kdsp/order-info/apply-refund`, data);
  },
  // 查看售后详情
  afterDetail(data) {
    return http.get(`${yxmGwHost}/api/kdsp/after-service/detail`, { params: data });
  },
  afterChangeHistory(data) {
    return http.get(`${yxmGwHost}/api/kdsp/after-service/change-history`, { params: data });
  },
  afterV2ChangeHistory(data) {
    return http.get(`${yxmGwHost}/api/kdsp/after-service/v2/change-history`, { params: data });
  },
  // 售后取消
  applyCancel(data) {
    return http.post(`${yxmGwHost}/api/kdsp/after-service/cancel`, data);
  },
  // 售后退货物流单信息填写 after-service/add-delivery-no
  addDeliveryNo(data) {
    return http.post(`${yxmGwHost}/api/kdsp/after-service/add-delivery-no`, data);
  },
  // 售后列表  after-service/list
  afterList(data) {
    return http.get(`${yxmGwHost}/api/kdsp/after-service/service/list`, { params: data });
  },
  // 售后催办 after-service/reminder
  afterReminder(data) {
    return http.post(`${yxmGwHost}/api/kdsp/after-service/reminder`, data);
  },
  // 发货中催办取消订单
  remindCancel(data) {
    return http.get(`${yxmGwHost}/api/kdsp/order-info/remindCancel`, { params: data });
  },
  // 撤销取消订单申请
  cancelRevoke(data) {
    return http.get(`${yxmGwHost}/api/kdsp/order-info/unfilled/cancel-revoke`, {
      params: data
    });
  },
  //查询售后是否在有效期
  applyExpired(data) {
    return http.get(`${yxmGwHost}/api/kdsp/after-service/expired`, { params: data });
  },
  // 获取七牛token
  getQiniuToken(data) {
    return http.get(`${yxmGwHost}/api/kdsp/common/upload/token`, { params: data });
  },
  // 校验手机号是否为 推广员手机号
  checkPromoterByMobile(phone) {
    return http.get(`${yxmGwHost}/api/kdsp/self-mention/checkPromoterByMobile?phoneNo=${phone}`);
  },
  // 申请退运费
  refundFreight(data) {
    return http.post(`${yxmGwHost}/api/kdsp/after-service/apply-freight-fee`, data);
  }
};
