import Vue from 'vue';

import App from './App.vue';
import router from './router';
import store from './store';
import '@/service/svg.service';
import '@/service/cherryUI.service';
import './style/index.less';
import saService from '@/service/sa.service';
import Bridge from '@qg/js-bridge';
import Raven from 'raven-js';
import RavenVue from 'raven-js/plugins/vue';
import { release } from '../.sentryclirc';
if (process.env.SENTRY_ENV !== 'test' && process.env.NODE_ENV === 'production') {
  Raven.config('//7b09a4aeffca4a49b37328da6a5468a9@sentry.q-gp.com/83', {
    release,
    environment: process.env.NODE_ENV
  })
    .addPlugin(RavenVue, Vue)
    .install();
}
Vue.prototype.util = new Bridge();
Vue.prototype.$track = saService;
saService.init(router);

Vue.config.productionTip = false;

new Vue({
  router,
  store,
  render: h => h(App)
}).$mount('#app');
