import UiTrack from '@qg/ui-track-web/src/index.js';
import router from '@/router';
import config from '@/config';
import { getVccChannel, getTenantId } from '@/service/userInfo.service';

const uiTrack = new UiTrack({
  globalVars: {
    platformType: 'H5',
    parent_channel_id: getVccChannel('vccChannel'),
    son_channel_id: getVccChannel('sonVccChannel'),
    tenant_id: getTenantId()
  },
  useUweb: false,
  batch: false,
  appTrack: false,
  shenceHost: config.shenceHost,
  showLog: config.test,
  router: router // router实例
});

export default uiTrack;
