import config from '@/config';
import http from '@/service/httpDecorator';
const { kdspOpHost } = config;

// 订单快照，需要提供后管token
export default {
  getOrderSnapshot(orderNo, auth) {
    return http.get(`${kdspOpHost}/api/kdsp/op/order/orderSkuInfolist?orderNo=${orderNo}`, {
      customHeader: {
        'access-token': auth
      }
    });
  },
  getSkuSnapshot(orderSkuId, skuNo, auth) {
    return http.get(
      `${kdspOpHost}/api/kdsp/op/order/orderSkuInfoDetail?skuId=${orderSkuId}&skuNo=${skuNo}`,
      {
        customHeader: {
          'access-token': auth
        }
      }
    );
  }
};
