import * as types from './type';
import localStorage from '@/service/localStorage.service';
import { changeDocumentTitle } from '@/service/utils.service';
const state = {
  header: false,
  title: '羊小咩',
  loading: false,
  meta: {},
  tabBar: true,
  userInfo: localStorage.get('userInfo') || {},
  hasLogin: false,
  routeIdx: 0,
  vccToken: '',
  vccChannel: '',
  tenantId: '',
  keepAliveMap: [],
  smDeviceId: ''
};

// 'creditToken',
//   'vccToken',
//   'vccChannel',
//   'sonVccChannel',
//   'formXcxPage',
//   'orderInfo',
//   'uuid'
// actions
const actions = {
  change_header({ commit }, header) {
    commit(types.CHANGE_HEADER, header);
  },
  change_tabBar({ commit }, tabBar) {
    commit(types.CHANGE_TABBAR, tabBar);
  },
  change_title({ commit }, title) {
    commit(types.CHANGE_TITLE, title);
  },
  change_meta({ commit }, meta) {
    commit(types.CHANGE_META, meta);
  },
  change_loading({ commit }, loading) {
    commit(types.CHANGE_LOADING, loading);
  },
  add_keep_alive({ commit }, name) {
    commit(types.ADD_KEEP_ALIVE, name);
  },
  del_keep_alive({ commit }, name) {
    commit(types.DEL_KEEP_ALIVE, name);
  },
  clear_keep_alive({ commit }, name) {
    commit(types.CLEAR_KEEP_ALIVE, name);
  },
  set_sm_device_id({ commit }, deviceId) {
    commit(types.SET_SM_DEVICEID, deviceId);
  },
  clear_userinfo({ commit }) {
    commit(types.DEL_USERINFO, {});
  }
};

// mutations
const mutations = {
  [types.VCC_CHANNEL](state, vccChannel) {
    state.vccChannel = vccChannel;
  },
  [types.QG_TENANT_ID](state, tenantId) {
    state.tenantId = tenantId;
  },

  [types.CHANGE_HEADER](state, header) {
    if (header !== undefined) {
      state.header = header;
    }
  },
  [types.CHANGE_LOGIN](state, provider) {
    state.userInfo = provider;
    localStorage.set('userInfo', provider);
  },
  [types.CHANGE_TOKEN](state, token) {
    state.hasLogin = !!token;
    state.vccToken = token;
    localStorage.set('vccToken', token);
  },
  [types.CHANGE_TABBAR](state, tabBar) {
    state.tabBar = tabBar;
  },
  [types.CHANGE_ROUTE_IDX](state, idx) {
    state.routeIdx = idx;
  },
  [types.CHANGE_LOADING](state, loading) {
    state.loading = loading;
  },
  [types.CHANGE_TITLE](state, title) {
    if (title) {
      state.title = title;
    }
    changeDocumentTitle(state.title);
  },
  [types.CHANGE_META](state, meta) {
    for (let i in meta) {
      state.meta[i] = meta[i];
    }
  },
  [types.ADD_KEEP_ALIVE](state, name) {
    const keepAliveMap = state.keepAliveMap;
    keepAliveMap.push(name);
    state.keepAliveMap = [...new Set(keepAliveMap)];
  },
  [types.DEL_KEEP_ALIVE](state, name) {
    state.keepAliveMap.splice(
      state.keepAliveMap.findIndex(item => item === name),
      1
    );
  },
  [types.CLEAR_KEEP_ALIVE](state) {
    state.keepAliveMap = [];
  },
  [types.SET_SM_DEVICEID](state, deviceId) {
    state.smDeviceId = deviceId;
  },
  [types.DEL_USERINFO](state) {
    state.userInfo = {};
  }
};

export default {
  state,
  actions,
  mutations
};
