import { queryStringify } from '@/service/utils.service';
// import localStorageService from '@/service/localStorage.service';
import { Img2Thumb } from '@/filters/img2Thumb.filter';
export default {
  filters: { Img2Thumb },
  methods: {
    goSimilar({ goodsId }) {
      this.openAppUrl('/browseSimilarity', { goodsId });
    },
    goToDetailPage(goods) {
      if (this.$bridge.isApp) {
        this.$bridge.openNewUrl({
          data: {
            newUrl: goods.jumpUrl
          }
        });
      } else {
        this.$router.push(`/goodDetail?skuNo=${goods.goodsId}`);
      }
    },
    openAppUrl(routeUrl, params = {}) {
      const queryParams = queryStringify(params);
      const successUrl = `${routeUrl}?${queryParams}`;
      if (this.$bridge.isApp) {
        const appUrl = `${successUrl}&vccToken={token}`;
        const offlineHost = this.$route.query.offlineHost; // 是否是离线包
        const url = offlineHost
          ? `https://${offlineHost}${appUrl}&offlineModule=xincheng`
          : `${window.location.origin}${appUrl}`;
        this.$bridge.openNewUrl({
          data: {
            newUrl: url
          }
        });
      } else {
        this.$router.push(successUrl);
      }
    },
    async addSkuToCart(goods) {
      const { goodsId: skuId, goodsType: skuSource } = goods;
      this.$track.registeredEvents(
        'APP_FeedCommodityCardCartBtnClick',
        {
          page_name: '浏览记录页'
        },
        async () => {
          const [res, error] = await this.$store.dispatch('shopCart/good_add', {
            type: 'ADD_CART',
            goodInfo: { selected: true, skuId, skuSource, skuNum: 1 }
          });
          if (!error) {
            this.$toast('购物车添加成功');
            this.$store.dispatch('shopCart/saveCartCount', res?.count);
          }
        }
      );
    }
  }
};
