import { getTokenFromApp } from '@/service/yxmLogin.service';
import { maxMember } from '@/api/member.api';
import { isApp } from '@/service/validation.service';
export default {
  methods: {
    // 加购
    async mxAddShopCart(goods) {
      if (goods.status === 2) return;
      if (goods.status === 1) {
        this.$toast('来晚了已经卖完了~');
        return;
      }
      try {
        await getTokenFromApp();
        const { skuNo, goodsId, skuSource } = goods;
        const params = [{ skuId: skuNo || goodsId, skuNum: 1, skuSource, type: 1 }];
        const [res, err] = await maxMember.addShopCart({
          shopCartBaseList: params,
          selected: true
        });
        if (res) {
          this.$toast.success('添加成功');
        } else if (err.response.businessCode === '401') {
          await getTokenFromApp(true);
        }
        if (isApp) {
          this.editor?.updateShopCartCount();
          this.nativeBridge.run({
            event: 'shopCarAddGoodsNotification',
            data: {
              count: res.count
            }
          });
        }
      } catch (error) {
        console.log(error);
      }
    }
  }
};
