/*
 * @Description: 活动相关api
 * @Date: 2020-09-27 11:49:59
 * @LastEditors: guang.wu
 * @LastEditTime: 2023-04-28 17:18:06
 */
import http from '@/service/httpDecorator';
import config from '@/config';
const { yxmGwHost, kdspHost } = config;

// 秒杀
export const spike = {
  // 活动专题列表
  activityList: activityId => {
    return http.get(`${yxmGwHost}/api/kdsp/activity/activity-goods-special/template-list`, {
      params: { activityId },
      hideLoading: 1
    });
  },
  // 商品列表
  goodslist: params => {
    return http.get(`${yxmGwHost}/api/kdsp/activity/activity-goods-special/goods-list`, {
      params,
      hideLoading: 1
    });
  },
  // 商品详情
  detail: params => {
    return http.post(`${yxmGwHost}/api/kdsp/activity/activity-goods-special/detail`, params, {
      hideLoading: 1
    });
  },
  getSkuInfo: data => {
    return http.post(`${kdspHost}/api/kdsp/activity/activity-goods-special/skus`, data);
  }
};

// 抢购
export const panicBuyingApi = {
  // 抢购信息
  activityInfo: activityInfoId => {
    return http.get(`${yxmGwHost}/api/kdsp/activity/rush-purchase/activity-info`, {
      params: { activityInfoId },
      hideLoading: 1
    });
  },
  // 商品列表
  goodsFeed: params => {
    return http.get(`${yxmGwHost}/api/kdsp/activity/rush-purchase/activity-goods`, {
      params,
      hideLoading: 1
    });
  }
};
