module.exports = (pagesJson) => {
  let basePages = [...require("./router/tabbar.js")];

  //todo 首页不应该依赖子包
  let baseSubPackages = [];
  let arr = ["pay"];
  if (process.env.NODE_ENV === "development") {
    // 开发模式下不需要开启预加载
    delete pagesJson.preloadRule;

    if (
      process.env?.VUE_APP_Module !== "all" &&
      process.env?.VUE_APP_Module !== ""
    ) {
      const tempArrs = process.env?.VUE_APP_Module?.split(",");
      if (tempArrs.length > 0) {
        arr = tempArrs;
      }
    } else if (process.env?.VUE_APP_Module === "") {
      arr = [];
    }
  } else {
    basePages.push(...require("./router/other.js"));
  }

  arr.forEach((module) => {
    if (module) {
      baseSubPackages.push(...require(`./subPackages/${module}/${module}.js`));
    }
  });
  console.log("jhb arr", arr);

  return {
    // 合并pages.json的内容
    ...pagesJson,
    pages: [...basePages],
    subPackages: [...baseSubPackages],
  };
};
