const creditPayStatusType = {
  1: "pwd",
  2: "sms"
};
const payTypeText = ["享花卡支付", "微信支付"];
const status = ["未申请", "审核中", "审核失败", "已有额度未激活", "开户成功"];
const payTypeE = [
  "PD_YXMMAEC_UserClickCashierSelectXiangHuaCardPay",
  "PD_YXMMAEC_UserClickCashierSelectWechatPay"
];
const codeArr = ["4034", "4035", "4036", "3005"];
// (4034, "密码错误"),
// (4035, "密码重试超限，无法验证"),
// (4036, "验证码错误");
// (3005, "组合支付方式被锁定")
// (6049, "token过期")

const payStatus = [3, 5]; // 展示支付文案
const creditStatus = [1, 2]; //展示开通文案

// (1, "VCC未申请"),
// (2, "VCC审核中"),
// (3, "VCC审核失败"),
// (4, "VCC审核成功未开户（包含开户失败）"),
// (5, "已开户"),;
const ACCOUNT_NO_APPLY = 1;
const ACCOUNT_APPLY_AUDITING = 2;
const ACCOUNT_APPLY_AUDIT_FAIL = 3;
const ACCOUNT_APPLY_FAIL = 4;
const ACCOUNT_APPLY_SUCCESS = 5;

const payTypeMap = {
  "1": "信用支付",
  "2": "微信支付",
  "3": "支付宝支付",
  "4": "信用支付_微信支付",
  "5": "信用支付_支付宝支付",
  "6": "虚拟支付0元付"
};

// 1信用支付 2微信支付 3支付宝支付 4信用支付_微信支付 5信用支付_支付宝支付 6虚拟支付0元
const CREDIT_PAY = 1;
const WECHAT_PAY = 2;
const ALIPAY_PAY = 3;
const CREDIT_AND_WECHAT_PAY = 4;
const CREDIT_AND_ALIPAY_PAY = 5;
const VIRTUAL_PAY = 6;

// 三方支付
const IS_THIRD_PAY = method => [WECHAT_PAY, VIRTUAL_PAY].indexOf(method) > -1;
//信用支付
const IS_CREDIT_PAY = method => [CREDIT_AND_WECHAT_PAY, CREDIT_PAY].indexOf(method) > -1;
//组合支付
const IS_GROUP_PAY = method => [CREDIT_AND_WECHAT_PAY].indexOf(method) > -1;

const PAYMENT_CODE_PAY = 1; // 支付密码
const SMS_VERIFICATION_CODE_PAY = 2; //短信验证码
const FACE_VERIFICATION_CODE_PAY = 4; //人脸验证
const CENTER_CODE_PAY = 5; //支付中

const PAY_SUCCESS = 3; // 支付成功
const PAY_PAYING = 2; //支付中

function isDetentionFn() {
  const { accountStatus } = this.creditPayInfo; // accountStatus 开通享花卡状态
  const { isGroupPay } = this.creditPayList; // isGroupPay 是否为组合支付
  const creditPayOpenDesc = this.creditPayInfo.creditPayOpenDesc;
  // 未开通享花卡时，推荐开通享花卡
  if (accountStatus !== ACCOUNT_APPLY_SUCCESS) {
    this.openConfigModal("freeQuota", creditPayOpenDesc);
  } else if (accountStatus === ACCOUNT_APPLY_SUCCESS && isGroupPay) {
    // 已经开通享花卡时，使用其他方式支付时推荐组合支付
    this.openConfigModal("detention", creditPayOpenDesc);
  } else if (accountStatus === ACCOUNT_APPLY_SUCCESS && !isGroupPay) {
    // 已经开通享花卡，但没有组合支付时推荐使用享花卡支付
    this.openConfigModal("jcardPay");
  }
}

function havePayingOrder() {
  /* 有享花卡未支付的订单 */
  uni.showModal({
    title: " ",
    content: "您的享花卡额度被其他订单占用，暂时不可使用享花卡支付哦！",
    showCancel: false,
    confirmText: "重新选择",
    confirmColor: "#ec1500"
  });
}

function filterAllPayList(type, data) {
  for (let item in data.payList) {
    if (data.payList[item].payType === type) {
      data.payList[item].isCheck = true;
      continue;
    }
    data.payList[item].isCheck = false;
  }
  return data;
}

export {
  creditPayStatusType,
  payTypeText,
  status,
  payTypeE,
  codeArr,
  payStatus,
  creditStatus,
  payTypeMap,
  // -------VCC未申请-------------
  ACCOUNT_NO_APPLY,
  ACCOUNT_APPLY_AUDITING,
  ACCOUNT_APPLY_AUDIT_FAIL,
  ACCOUNT_APPLY_FAIL,
  ACCOUNT_APPLY_SUCCESS,
  // -------VCC未申请-------------
  // -------信用支付账户状态--------
  CREDIT_PAY,
  WECHAT_PAY,
  ALIPAY_PAY,
  VIRTUAL_PAY,
  CREDIT_AND_WECHAT_PAY,
  CREDIT_AND_ALIPAY_PAY,
  // -------信用支付账户状态--------
  IS_CREDIT_PAY,
  IS_GROUP_PAY,
  IS_THIRD_PAY,
  // --------------
  PAYMENT_CODE_PAY, // 支付密码
  SMS_VERIFICATION_CODE_PAY, //短信验证码
  FACE_VERIFICATION_CODE_PAY, //人脸验证
  CENTER_CODE_PAY, //支付中
  PAY_SUCCESS,
  PAY_PAYING,
  filterAllPayList,
  havePayingOrder,
  isDetentionFn
};
