const path = require("path");
const resolve = dir => path.join(__dirname, dir);
module.exports = {
  transpileDependencies: ["uview-ui", "@qg/miniapp-qa-tool"],
  css: {
    loaderOptions: {
      less: {
        // 若使用 less-loader@5，请移除 lessOptions 这一级，直接配置选项。
        modifyVars: {
          // 直接覆盖变量
          hack: `true; @import "${resolve("./src/style/theme.less")}";`
        }
      }
    }
  },
  configureWebpack: () => {
    return {
      optimization: {
        minimize: true,
        usedExports: true
      }
    };
  }
};
