import Vue from "vue";
import store from "./store";
import App from "./App";
import { saInit } from "@/utils/sa";
import uView from "uview-ui";

const msg = (title, duration = 1500, mask = false, icon = "none") => {
  //统一提示方便全局修改
  if (Boolean(title) === false) {
    return;
  }
  uni.showToast({
    title,
    /* #ifndef MP-ALIPAY */
    duration,
    mask,
    icon
    /* #endif */
  });
};
const json = type => {
  //模拟异步请求数据
  return new Promise(resolve => {
    setTimeout(() => {
      // eslint-disable-next-line no-undef
      resolve(Json[type]);
    }, 500);
  });
};

const prePage = () => {
  let pages = getCurrentPages();
  let prePage = pages[pages.length - 2];
  // #ifdef H5
  return prePage;
  // #endif
  // eslint-disable-next-line no-unreachable
  return prePage.$vm;
};
Page.after = () => {};

Vue.config.productionTip = false;
Vue.prototype.$fire = new Vue();
// #ifdef MP-WEIXIN
const accountInfo = wx.getAccountInfoSync();
if (accountInfo.miniProgram.appId === "wxb3e6270e1b1e0bc7") {
  Vue.prototype.$ry = require("utils/reyunwx.js");
}
// #endif
Vue.prototype.$store = store;
Vue.prototype.$api = { msg, json, prePage };
Vue.prototype.$config = key => {
  return getApp().globalData[key];
};
Vue.use(uView);

// 挂载全局变量
uni.$u.gData = {
  ua: uni.getSystemInfoSync().ua || "" // 全局ua
};
console.log("jhb ua", uni.$u.gData.ua);

saInit();
App.mpType = "app";

const app = new Vue({
  ...App
});
app.$mount();
