export const sStorage = {
  setItem(key, value) {
    uni.setStorageSync(key, value);
  },
  getItem(key) {
    return uni.getStorageSync(key);
  },
  removeItem(key) {
    uni.removeStorageSync(key);
  },
  clear() {
    uni.clearStorageSync();
  },
  /**
   * @function 判断类型
   * @param {any} para 必须参数，判断的值
   */
  getType(para) {
    const type = typeof para;
    if (type === "number" && isNaN(para)) return "NaN";
    if (type !== "object") return type;
    return Object.prototype.toString
      .call(para)
      .replace(/[\[\]]/g, '') // eslint-disable-line
      .split(" ")[1]
      .toLowerCase();
  }
};
