export default [
  {
    path: '/',
    redirect: '/pay'
  },
  {
    path: '/pay',
    name: 'pay',
    meta: {
      title: '收银台'
    },
    component: () => import('../views/pay')
  },
  {
    path: '/payFail',
    name: 'payFail',
    alias: ['/payFail'],
    meta: {
      title: '支付失败'
    },
    component: () => import('../views/pay/payResult')
  },
  {
    path: '/paySuccess',
    name: 'paySuccess',
    alias: ['/paySuccess'],
    meta: {
      title: '支付成功',
      success: true
    },
    component: () => import('../views/pay/payResult')
  },
  {
    path: '/payWaiting',
    name: 'payWaiting',
    meta: {
      title: '支付中',
      success: true
    },
    component: () => import('../views/pay/payWaiting')
  },
  {
    path: '/error',
    name: 'error',
    meta: {
      title: '出错了'
    },
    component: () => import('../components/error')
  },
  {
    path: '*',
    name: 'notFound',
    meta: {
      title: '找不到页面'
    },
    component: () => import('../components/error/NotFound')
  }
];
