import request from "../utils/request";
import config from "@/config";
const { talosApi, yxmGateway } = config;
// const yapiHost = "http://yapi.quantgroups.com/mock/499";
const queryPayInfo = function(data) {
  // return request.post("http://yapi.quantgroups.com/mock/410/open/checkout", data);
  return request.post(`${talosApi}/open/checkout`, data, {
    hideToast: true
  });
};
const prepay = function(data) {
  const tenantId = +uni.getStorageSync("tenantId");
  if (tenantId === 560761) {
    return request.post(`${talosApi}/open/checkout/v2/prepay`, data);
  } else {
    return request.post(`${talosApi}/open/checkout/prepay`, data);
  }
};

const pay = function(data) {
  const tenantId = +uni.getStorageSync("tenantId");
  if (tenantId === 560761) {
    return request.post(`${talosApi}/open/checkout/v2/pay`, data, {
      needScDeviceId: true
    });
  } else {
    return request.post(`${talosApi}/open/checkout/pay`, data, {
      needScDeviceId: true
    });
  }
};

const queryPayStatus = function(data) {
  const tenantId = +uni.getStorageSync("tenantId");
  if (tenantId === 560761) {
    return request.post(`${talosApi}/open/checkout/v2/pay_status/query`, data);
  } else {
    return request.post(`${talosApi}/open/checkout/pay_status/query`, data);
  }
};

const sendSms = function(data) {
  return request.post(`${talosApi}/open/checkout/send_sms`, data);
};

const desSalt = function() {
  return request.get(`${talosApi}/vcc/account/salt`);
};

const h5AppyUrl = function() {
  return request.get(`${talosApi}/vcc/xyqb_mall/app_url`);
};

const getCoupon = function(params) {
  // return request.post(`http://yapi.quantgroups.com/mock/499/x/checkout/pay_coupon_list`, params);
  return request.post(`${talosApi}/open/checkout/pay_coupon_list`, params);
};

const reissueContract = function(params) {
  return request.post(`${talosApi}/open/checkout/payReissueContract`, params);
};

const guideStream = function(data) {
  return request.get(`${yxmGateway}/api/kdsp/appconfig/pay-succ-page/guide-stream`, data);
};

const getOrderType = function(data) {
  return request.get(`${yxmGateway}/api/kdsp/checkIsHundredGroupOrder?orderNo=${data}`);
};
const getPrivDomain = function(data) {
  return request.get(`${yxmGateway}/api/kdsp/appconfig/private-domain/detail?activityType=${data}`);
};
export {
  pay,
  prepay,
  sendSms,
  queryPayInfo,
  queryPayStatus,
  desSalt,
  h5AppyUrl,
  getCoupon,
  reissueContract,
  guideStream,
  getOrderType,
  getPrivDomain
};
